/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.xfire;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.transport.TransportManager;
import org.mule.api.lifecycle.Callable;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.util.ClassUtils;

public class MuleObjectServiceFactory
extends ObjectServiceFactory {
    protected final Set excludedMethods = new HashSet();

    public MuleObjectServiceFactory(TransportManager transportManager) {
        super(transportManager);
        this.initExcludedMethods();
    }

    protected void initExcludedMethods() {
        this.addIgnoredMethods("java.lang.Object");
        this.addIgnoredMethods("java.lang.Throwable");
        this.addIgnoredMethods("org.omg.CORBA_2_3.portable.ObjectImpl");
        this.addIgnoredMethods("org.omg.CORBA.portable.ObjectImpl");
        this.addIgnoredMethods("javax.ejb.EJBObject");
        this.addIgnoredMethods("javax.rmi.CORBA.Stub");
        this.addIgnoredMethods(Callable.class.getName());
        this.addIgnoredMethods(Initialisable.class.getName());
        this.addIgnoredMethods(Disposable.class.getName());
    }

    public void addIgnoredMethods(String className) {
        try {
            Class c = ClassUtils.loadClass((String)className, ((Object)((Object)this)).getClass());
            for (int i = 0; i < c.getMethods().length; ++i) {
                this.excludedMethods.add(this.getMethodName(c.getMethods()[i]));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    protected boolean isValidMethod(Method method) {
        if (this.excludedMethods.contains(this.getMethodName(method))) {
            return false;
        }
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers);
    }

    protected String getMethodName(Method method) {
        return method.getName();
    }
}

