/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.xfire;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.xfire.DefaultXFire;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.aegis.AegisBindingProvider;
import org.codehaus.xfire.aegis.type.TypeMappingRegistry;
import org.codehaus.xfire.annotations.AnnotationServiceFactory;
import org.codehaus.xfire.annotations.WebAnnotations;
import org.codehaus.xfire.client.Client;
import org.codehaus.xfire.handler.Handler;
import org.codehaus.xfire.service.ServiceFactory;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.wsdl11.builder.WSDLBuilderFactory;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.WorkManager;
import org.mule.api.context.notification.ManagerNotificationListener;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.routing.InboundRouterCollection;
import org.mule.api.service.Service;
import org.mule.api.transport.Connectable;
import org.mule.api.transport.MessageReceiver;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.NotificationException;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.model.seda.SedaService;
import org.mule.routing.inbound.DefaultInboundRouterCollection;
import org.mule.transformer.TransformerUtils;
import org.mule.transport.AbstractConnectable;
import org.mule.transport.AbstractConnector;
import org.mule.transport.FatalConnectException;
import org.mule.transport.soap.xfire.MuleHeadersInHandler;
import org.mule.transport.soap.xfire.MuleHeadersOutHandler;
import org.mule.transport.soap.xfire.MuleObjectServiceFactory;
import org.mule.transport.soap.xfire.XFireMessageDispatcher;
import org.mule.transport.soap.xfire.XFireMessageReceiver;
import org.mule.transport.soap.xfire.XFireServiceComponent;
import org.mule.transport.soap.xfire.i18n.XFireMessages;
import org.mule.transport.soap.xfire.transport.MuleLocalTransport;
import org.mule.transport.soap.xfire.transport.MuleUniversalTransport;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;
import org.mule.util.SystemUtils;
import org.mule.util.object.ObjectFactory;
import org.mule.util.object.SingletonObjectFactory;

public class XFireConnector
extends AbstractConnector
implements ManagerNotificationListener {
    public static final String XFIRE = "xfire";
    public static final String XFIRE_SERVICE_COMPONENT_NAME = "_xfireServiceComponent";
    public static final String DEFAULT_MULE_NAMESPACE_URI = "http://www.muleumo.org";
    public static final String XFIRE_PROPERTY = "xfire";
    public static final String XFIRE_TRANSPORT = "transportClass";
    public static final String CLASSNAME_ANNOTATIONS = "org.codehaus.xfire.annotations.jsr181.Jsr181WebAnnotations";
    private static final String DEFAULT_BINDING_PROVIDER_CLASS = "org.codehaus.xfire.aegis.AegisBindingProvider";
    private static final String DEFAULT_TYPE_MAPPING_muleRegistry_CLASS = "org.codehaus.xfire.aegis.type.DefaultTypeMappingRegistry";
    private XFire xfire;
    private ServiceFactory serviceFactory;
    private boolean enableJSR181Annotations = false;
    private List components = new ArrayList();
    private List clientServices = null;
    private List clientInHandlers = null;
    private List clientOutHandlers = null;
    private String clientTransport = null;
    private String bindingProvider = null;
    private String typeMappingRegistry = null;
    private String serviceTransport = null;
    private List serverInHandlers = null;
    private List serverOutHandlers = null;
    private MuleUniversalTransport universalTransport;
    private Transport transport;
    private String transportClass;

    public XFireConnector() {
        this.registerProtocols();
        this.setDynamicNotification(true);
    }

    protected void registerProtocols() {
        this.registerSupportedProtocol("http");
        this.registerSupportedProtocol("https");
        this.registerSupportedProtocol("jms");
        this.registerSupportedProtocol("vm");
        this.registerSupportedProtocol("servlet");
    }

    public String getProtocol() {
        return "xfire";
    }

    protected void doInitialise() throws InitialisationException {
        ObjectServiceFactory osf;
        try {
            this.muleContext.registerListener((ServerNotificationListener)this);
        }
        catch (NotificationException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        if (this.xfire == null) {
            this.xfire = new DefaultXFire();
        }
        if (this.clientServices != null) {
            ObjectServiceFactory factory = new ObjectServiceFactory();
            this.configureBindingProvider(factory);
            for (int i = 0; i < this.clientServices.size(); ++i) {
                try {
                    Class clazz = ClassUtils.loadClass((String)this.clientServices.get(i).toString(), ((Object)((Object)this)).getClass());
                    org.codehaus.xfire.service.Service xfireService = factory.create(clazz);
                    this.xfire.getServiceRegistry().register(xfireService);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new InitialisationException(XFireMessages.couldNotInitAnnotationProcessor(this.clientServices.get(i)), (Throwable)e, (Initialisable)this);
                }
            }
        }
        if (this.serviceFactory == null) {
            if (this.enableJSR181Annotations) {
                if (!SystemUtils.isJavaVersionAtLeast((int)150)) {
                    throw new InitialisationException(XFireMessages.annotationsRequireJava5(), (Initialisable)this);
                }
                try {
                    WebAnnotations wa = (WebAnnotations)ClassUtils.instanciateClass((String)CLASSNAME_ANNOTATIONS, null, ((Object)((Object)this)).getClass());
                    this.serviceFactory = new AnnotationServiceFactory(wa, this.xfire.getTransportManager());
                    this.configureBindingProvider((ObjectServiceFactory)this.serviceFactory);
                }
                catch (Exception ex) {
                    throw new InitialisationException(XFireMessages.couldNotInitAnnotationProcessor(CLASSNAME_ANNOTATIONS), (Throwable)ex, (Initialisable)this);
                }
            } else {
                this.serviceFactory = new MuleObjectServiceFactory(this.xfire.getTransportManager());
                this.configureBindingProvider((ObjectServiceFactory)this.serviceFactory);
            }
        }
        if (this.serviceFactory instanceof ObjectServiceFactory && (osf = (ObjectServiceFactory)this.serviceFactory).getTransportManager() == null) {
            osf.setTransportManager(this.xfire.getTransportManager());
        }
        WorkManager wm = this.getReceiverThreadingProfile().createWorkManager("xfire-local-transport");
        try {
            wm.start();
        }
        catch (MuleException e) {
            throw new MuleRuntimeException(CoreMessages.failedToStart((String)"local channel work manager"), (Throwable)e);
        }
        this.createLocalTransport(wm);
        this.xfire.getTransportManager().register(this.transport);
        this.universalTransport = new MuleUniversalTransport();
        this.xfire.getTransportManager().register((Transport)this.universalTransport);
    }

    protected void createLocalTransport(WorkManager wm) {
        if (this.transportClass == null) {
            this.transport = new MuleLocalTransport(wm);
        } else {
            try {
                Constructor constructor;
                Class transportClazz;
                block7: {
                    transportClazz = ClassUtils.loadClass((String)this.transportClass, ((Object)((Object)this)).getClass());
                    try {
                        constructor = transportClazz.getConstructor(WorkManager.class);
                        this.transport = (Transport)constructor.newInstance(wm);
                    }
                    catch (NoSuchMethodException ne) {
                        if (!this.logger.isDebugEnabled()) break block7;
                        this.logger.debug((Object)ne.getCause());
                    }
                }
                if (this.transport == null) {
                    constructor = transportClazz.getConstructor(null);
                    this.transport = (Transport)constructor.newInstance(null);
                }
            }
            catch (Exception e) {
                throw new MuleRuntimeException(CoreMessages.failedToLoad((String)"xfire service transport"), (Throwable)e);
            }
        }
    }

    protected void configureBindingProvider(ObjectServiceFactory factory) throws InitialisationException {
        if (StringUtils.isBlank((String)this.bindingProvider)) {
            this.bindingProvider = DEFAULT_BINDING_PROVIDER_CLASS;
        }
        if (StringUtils.isBlank((String)this.typeMappingRegistry)) {
            this.typeMappingRegistry = DEFAULT_TYPE_MAPPING_muleRegistry_CLASS;
        }
        try {
            Class clazz = ClassUtils.loadClass((String)this.bindingProvider, ((Object)((Object)this)).getClass());
            BindingProvider provider = (BindingProvider)ClassUtils.instanciateClass((Class)clazz, (Object[])new Object[0]);
            if (this.bindingProvider.equals(DEFAULT_BINDING_PROVIDER_CLASS) && !this.typeMappingRegistry.equals(DEFAULT_TYPE_MAPPING_muleRegistry_CLASS)) {
                Class registryClazz = ClassUtils.loadClass((String)this.typeMappingRegistry, ((Object)((Object)this)).getClass());
                TypeMappingRegistry registry = (TypeMappingRegistry)ClassUtils.instanciateClass((Class)registryClazz, (Object[])new Object[0]);
                ((AegisBindingProvider)provider).setTypeMappingRegistry(registry);
            }
            factory.setBindingProvider(provider);
            String wsdlBuilderFactoryClass = null;
            if (this.bindingProvider.equals("org.codehaus.xfire.service.binding.MessageBindingProvider")) {
                factory.setStyle("message");
            }
            if (wsdlBuilderFactoryClass != null) {
                Class wsdlBuilderFactoryClazz = ClassUtils.loadClass(wsdlBuilderFactoryClass, ((Object)((Object)this)).getClass());
                WSDLBuilderFactory wsdlBuilderFactory = (WSDLBuilderFactory)ClassUtils.instanciateClass((Class)wsdlBuilderFactoryClazz, (Object[])new Object[0]);
                factory.setWsdlBuilderFactory(wsdlBuilderFactory);
            }
        }
        catch (Exception ex) {
            throw new InitialisationException(XFireMessages.unableToInitBindingProvider(this.bindingProvider), (Throwable)ex, (Initialisable)this);
        }
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    public XFire getXfire() {
        return this.xfire;
    }

    public void setXfire(XFire xfire) {
        this.xfire = xfire;
    }

    protected void registerReceiverWithMuleService(MessageReceiver receiver, EndpointURI ep) throws MuleException {
        SedaService c = new SedaService();
        c.setName(XFIRE_SERVICE_COMPONENT_NAME + receiver.getService().getName());
        c.setModel(this.muleContext.getRegistry().lookupSystemModel());
        XFireServiceComponent svcComponent = new XFireServiceComponent((XFireMessageReceiver)receiver);
        svcComponent.setXfire(this.xfire);
        svcComponent.setTransport(this.transport);
        svcComponent.initialise();
        SingletonObjectFactory of = new SingletonObjectFactory((Object)svcComponent);
        of.setService((Service)c);
        of.initialise();
        c.setServiceFactory((ObjectFactory)of);
        if (c.getProperties().get("xfire") == null) {
            c.getProperties().put("xfire", this.xfire);
        }
        if (this.serviceTransport != null && c.getProperties().get(XFIRE_TRANSPORT) == null) {
            c.getProperties().put(XFIRE_TRANSPORT, this.serviceTransport);
        }
        String serviceName = receiver.getService().getName();
        String endpoint = receiver.getEndpointURI().getAddress();
        String scheme = ep.getScheme().toLowerCase();
        boolean sync = receiver.getEndpoint().isSynchronous();
        if (scheme.equals("http") || scheme.equals("https") || scheme.equals("ssl") || scheme.equals("tcp") || scheme.equals("servlet")) {
            endpoint = endpoint + "/" + serviceName;
            receiver.getEndpoint().getProperties().put("http.method", "POST");
            receiver.getEndpoint().getProperties().put("Content-Type", "text/xml");
        }
        EndpointURIEndpointBuilder serviceEndpointbuilder = new EndpointURIEndpointBuilder(endpoint, this.muleContext);
        serviceEndpointbuilder.setSynchronous(sync);
        serviceEndpointbuilder.setName(ep.getScheme() + ":" + serviceName);
        serviceEndpointbuilder.setTransformers(receiver.getEndpoint().getTransformers());
        serviceEndpointbuilder.setResponseTransformers(receiver.getEndpoint().getResponseTransformers());
        serviceEndpointbuilder.setFilter(receiver.getEndpoint().getFilter());
        serviceEndpointbuilder.setSecurityFilter(receiver.getEndpoint().getSecurityFilter());
        EndpointURIEndpointBuilder receiverEndpointBuilder = new EndpointURIEndpointBuilder(receiver.getEndpoint(), this.muleContext);
        receiverEndpointBuilder.setTransformers(TransformerUtils.UNDEFINED);
        receiverEndpointBuilder.setResponseTransformers(TransformerUtils.UNDEFINED);
        receiverEndpointBuilder.setFilter(null);
        receiverEndpointBuilder.setSecurityFilter(null);
        ImmutableEndpoint serviceEndpoint = this.muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint((EndpointBuilder)serviceEndpointbuilder);
        ImmutableEndpoint receiverEndpoint = this.muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint((EndpointBuilder)receiverEndpointBuilder);
        receiver.setEndpoint(receiverEndpoint);
        c.setInboundRouter((InboundRouterCollection)new DefaultInboundRouterCollection());
        c.getInboundRouter().addEndpoint(serviceEndpoint);
        this.components.add(c);
    }

    public ServiceFactory getServiceFactory() {
        return this.serviceFactory;
    }

    public void setServiceFactory(ServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    protected Object getReceiverKey(Service service, ImmutableEndpoint endpoint) {
        if (endpoint.getEndpointURI().getPort() == -1) {
            return service.getName();
        }
        return endpoint.getEndpointURI().getAddress() + "/" + service.getName();
    }

    public boolean isEnableJSR181Annotations() {
        return this.enableJSR181Annotations;
    }

    public void setEnableJSR181Annotations(boolean enableJSR181Annotations) {
        this.enableJSR181Annotations = enableJSR181Annotations;
    }

    public List getClientServices() {
        return this.clientServices;
    }

    public void setClientServices(List clientServices) {
        this.clientServices = clientServices;
    }

    public List getClientInHandlers() {
        return this.clientInHandlers;
    }

    public void setClientInHandlers(List handlers) {
        this.clientInHandlers = handlers;
    }

    public List getClientOutHandlers() {
        return this.clientOutHandlers;
    }

    public void setClientOutHandlers(List handlers) {
        this.clientOutHandlers = handlers;
    }

    public String getClientTransport() {
        return this.clientTransport;
    }

    public void setClientTransport(String transportClass) {
        this.clientTransport = transportClass;
    }

    public String getServiceTransport() {
        return this.serviceTransport;
    }

    public void setServiceTransport(String transportClass) {
        this.serviceTransport = transportClass;
    }

    public String getBindingProvider() {
        return this.bindingProvider;
    }

    public void setBindingProvider(String bindingProvider) {
        this.bindingProvider = bindingProvider;
    }

    public String getTypeMappingRegistry() {
        return this.typeMappingRegistry;
    }

    public void setTypeMappingRegistry(String typeMappingRegistry) {
        this.typeMappingRegistry = typeMappingRegistry;
    }

    public void onNotification(ServerNotification event) {
        if (event.getAction() == 104) {
            for (Service c : this.components) {
                try {
                    this.muleContext.getRegistry().registerService(c);
                }
                catch (MuleException e) {
                    this.handleException((Exception)((Object)e));
                }
            }
        }
    }

    public List getServerInHandlers() {
        return this.serverInHandlers;
    }

    public void setServerInHandlers(List serverInHandlers) {
        this.serverInHandlers = serverInHandlers;
    }

    public List getServerOutHandlers() {
        return this.serverOutHandlers;
    }

    public void setServerOutHandlers(List serverOutHandlers) {
        this.serverOutHandlers = serverOutHandlers;
    }

    public void setTransportClass(String clazz) {
        this.transportClass = clazz;
    }

    public boolean isSyncEnabled(ImmutableEndpoint endpoint) {
        String scheme = endpoint.getEndpointURI().getScheme().toLowerCase();
        if (scheme.equals("http") || scheme.equals("https") || scheme.equals("ssl") || scheme.equals("tcp") || scheme.equals("servlet")) {
            return true;
        }
        return super.isSyncEnabled(endpoint);
    }

    protected Client createXFireClient(ImmutableEndpoint endpoint, org.codehaus.xfire.service.Service service, XFire xfire) throws Exception {
        return this.createXFireClient(endpoint, service, xfire, null);
    }

    protected Client createXFireClient(ImmutableEndpoint endpoint, org.codehaus.xfire.service.Service service, XFire xfire, String transportClass) throws Exception {
        Class transportClazz = MuleUniversalTransport.class;
        if (this.getClientTransport() == null) {
            if (!StringUtils.isBlank((String)transportClass)) {
                transportClazz = ClassUtils.loadClass((String)transportClass, ((Object)((Object)this)).getClass());
            }
        } else {
            transportClazz = ClassUtils.loadClass((String)this.getClientTransport(), ((Object)((Object)this)).getClass());
        }
        Transport transport = (Transport)transportClazz.getConstructor(null).newInstance(null);
        Client client = new Client(transport, service, endpoint.getEndpointURI().getUri().toString());
        client.setXFire(xfire);
        client.setEndpointUri(endpoint.getEndpointURI().getUri().toString());
        return this.configureXFireClient(client);
    }

    public Client configureXFireClient(Client client) throws Exception {
        List outList;
        client.addInHandler((Handler)new MuleHeadersInHandler());
        client.addOutHandler((Handler)new MuleHeadersOutHandler());
        List inList = this.getClientInHandlers();
        if (inList != null) {
            for (int i = 0; i < inList.size(); ++i) {
                Class clazz = ClassUtils.loadClass((String)inList.get(i).toString(), ((Object)((Object)this)).getClass());
                Handler handler = (Handler)clazz.getConstructor(null).newInstance(null);
                client.addInHandler(handler);
            }
        }
        if ((outList = this.getClientOutHandlers()) != null) {
            for (int i = 0; i < outList.size(); ++i) {
                Class clazz = ClassUtils.loadClass((String)outList.get(i).toString(), ((Object)((Object)this)).getClass());
                Handler handler = (Handler)clazz.getConstructor(null).newInstance(null);
                client.addOutHandler(handler);
            }
        }
        return client;
    }

    protected Client doClientConnect(ImmutableEndpoint endpoint, AbstractConnectable connectable) throws Exception {
        List outList;
        XFire xfire = this.getXfire();
        String serviceName = XFireMessageDispatcher.getServiceName(endpoint);
        org.codehaus.xfire.service.Service xfireService = xfire.getServiceRegistry().getService(serviceName);
        if (xfireService == null) {
            throw new FatalConnectException(XFireMessages.serviceIsNull(serviceName), (Connectable)this);
        }
        List inList = this.getServerInHandlers();
        if (inList != null) {
            for (int i = 0; i < inList.size(); ++i) {
                Handler handler = (Handler)ClassUtils.instanciateClass((String)inList.get(i).toString(), (Object[])ClassUtils.NO_ARGS, ((Object)((Object)this)).getClass());
                xfireService.addInHandler(handler);
            }
        }
        if ((outList = this.getServerOutHandlers()) != null) {
            for (int i = 0; i < outList.size(); ++i) {
                Handler handler = (Handler)ClassUtils.instanciateClass((String)outList.get(i).toString(), (Object[])ClassUtils.NO_ARGS, ((Object)((Object)this)).getClass());
                xfireService.addOutHandler(handler);
            }
        }
        try {
            return this.createXFireClient(endpoint, xfireService, xfire);
        }
        catch (Exception ex) {
            connectable.disconnect();
            throw ex;
        }
    }
}

