/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.xfire;

import java.util.Iterator;
import javax.activation.DataHandler;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.attachments.Attachment;
import org.codehaus.xfire.attachments.Attachments;
import org.codehaus.xfire.attachments.SimpleAttachment;
import org.jdom.Element;
import org.jdom.Namespace;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.MessageAdapter;
import org.mule.transformer.simple.SerializableToByteArray;
import org.mule.transport.AbstractMessageAdapter;

public class XFireMessageAdapter
extends AbstractMessageAdapter {
    private static final long serialVersionUID = 419878758858206446L;
    private final Object payload;
    private MessageContext messageContext;
    private Transformer trans = new SerializableToByteArray();

    public XFireMessageAdapter(Object message) {
        this.payload = message;
    }

    protected XFireMessageAdapter(XFireMessageAdapter template) {
        super((MessageAdapter)template);
        this.payload = template.payload;
        this.messageContext = template.messageContext;
    }

    public Object getPayload() {
        return this.payload;
    }

    public void addAttachment(String name, DataHandler dataHandler) throws Exception {
        this.messageContext.getInMessage().getAttachments().addPart((Attachment)new SimpleAttachment(name, dataHandler));
        super.addAttachment(name, dataHandler);
    }

    public void removeAttachment(String name) throws Exception {
        throw new UnsupportedOperationException("XFIRE: removeAttachment");
    }

    public MessageContext getMessageContext() {
        return this.messageContext;
    }

    void setMessageContext(MessageContext messageContext) {
        this.messageContext = messageContext;
        this.initHeaders();
        this.initAttachments();
    }

    protected void initHeaders() {
        if (this.messageContext.getInMessage() != null) {
            Element header = this.messageContext.getInMessage().getHeader();
            if (header == null) {
                return;
            }
            Namespace ns = Namespace.getNamespace((String)"mule", (String)"http://www.muleumo.org/providers/soap/1.0");
            Element muleHeaders = header.getChild("header", ns);
            if (muleHeaders != null) {
                Element child = muleHeaders.getChild("MULE_CORRELATION_ID", ns);
                if (child != null) {
                    this.setCorrelationId(child.getText());
                }
                if ((child = muleHeaders.getChild("MULE_CORRELATION_GROUP_SIZE", ns)) != null) {
                    this.setCorrelationGroupSize(Integer.valueOf(child.getText()));
                }
                if ((child = muleHeaders.getChild("MULE_CORRELATION_SEQUENCE", ns)) != null) {
                    this.setCorrelationSequence(Integer.valueOf(child.getText()));
                }
                if ((child = muleHeaders.getChild("MULE_REPLYTO", ns)) != null) {
                    this.setReplyTo(child.getText());
                }
            }
        }
    }

    protected void initAttachments() {
        try {
            Attachments atts = this.messageContext.getInMessage().getAttachments();
            if (atts != null) {
                Iterator i = atts.getParts();
                while (i.hasNext()) {
                    Attachment att = (Attachment)i.next();
                    super.addAttachment(att.getId(), att.getDataHandler());
                }
            }
        }
        catch (Exception e) {
            logger.fatal((Object)"Failed to read attachments", (Throwable)e);
        }
    }

    public ThreadSafeAccess newThreadCopy() {
        return new XFireMessageAdapter(this);
    }
}

