/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.xfire;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.codehaus.xfire.aegis.AegisBindingProvider;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.TypeMapping;
import org.codehaus.xfire.aegis.type.basic.BeanType;
import org.codehaus.xfire.client.Client;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.MessageAdapter;
import org.mule.transport.AbstractConnectable;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.soap.i18n.SoapMessages;
import org.mule.transport.soap.xfire.XFireConnector;
import org.mule.util.StringUtils;
import org.mule.util.TemplateParser;

public class XFireMessageDispatcher
extends AbstractMessageDispatcher {
    protected Client client = null;
    protected final XFireConnector connector;
    private final TemplateParser soapActionTemplateParser = TemplateParser.createAntStyleParser();

    public XFireMessageDispatcher(ImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (XFireConnector)endpoint.getConnector();
    }

    protected void doConnect() throws Exception {
        if (this.client == null) {
            this.client = this.connector.doClientConnect(this.endpoint, (AbstractConnectable)this);
        }
    }

    protected void doDisconnect() throws Exception {
        this.client = null;
    }

    protected void doDispose() {
    }

    protected String getMethod(MuleEvent event) throws DispatchException {
        String method = (String)event.getMessage().getProperty("method");
        if (method == null) {
            EndpointURI endpointUri = event.getEndpoint().getEndpointURI();
            method = (String)endpointUri.getParams().get("method");
        }
        if (method == null) {
            method = (String)event.getEndpoint().getProperties().get("method");
        }
        if (method == null) {
            throw new DispatchException(SoapMessages.cannotInvokeCallWithoutOperation(), event.getMessage(), event.getEndpoint());
        }
        return method;
    }

    protected Object[] getArgs(MuleEvent event) throws TransformerException {
        Object payload = event.transformMessage();
        Object[] args = payload instanceof Object[] ? (Object[])payload : new Object[]{payload};
        MuleMessage message = event.getMessage();
        Set attachmentNames = message.getAttachmentNames();
        if (attachmentNames != null && !attachmentNames.isEmpty()) {
            ArrayList<DataHandler> attachments = new ArrayList<DataHandler>();
            Iterator i = attachmentNames.iterator();
            while (i.hasNext()) {
                attachments.add(message.getAttachment((String)i.next()));
            }
            ArrayList<Object> temp = new ArrayList<Object>(Arrays.asList(args));
            temp.add(attachments.toArray(new DataHandler[0]));
            args = temp.toArray();
        }
        return args;
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        if (event.getEndpoint().getProperty((Object)"complexTypes") != null) {
            this.configureClientForComplexTypes(this.client, event);
        }
        this.client.setTimeout(event.getTimeout());
        this.client.setProperty("MULE_EVENT", (Object)event);
        String method = this.getMethod(event);
        String soapAction = (String)event.getMessage().getProperty("soapAction");
        if (soapAction != null) {
            soapAction = this.parseSoapAction(soapAction, new QName(method), event);
            this.client.setProperty("SOAPAction", (Object)soapAction);
        }
        Object[] arr = event.getMessage().getPropertyNames().toArray();
        for (int i = 0; i < arr.length; ++i) {
            String head = (String)arr[i];
            if (head == null || head.startsWith("MULE")) continue;
            this.client.setProperty((String)arr[i], event.getMessage().getProperty((String)arr[i]));
        }
        Object[] response = this.client.invoke(method, this.getArgs(event));
        DefaultMuleMessage result = null;
        if (response != null && response.length <= 1) {
            if (response.length == 1) {
                result = new DefaultMuleMessage(response[0], (MessageAdapter)event.getMessage());
            }
        } else {
            result = new DefaultMuleMessage((Object)response, (MessageAdapter)event.getMessage());
        }
        return result;
    }

    protected void doDispatch(MuleEvent event) throws Exception {
        this.client.setTimeout(event.getTimeout());
        this.client.setProperty("MULE_EVENT", (Object)event);
        this.client.invoke(this.getMethod(event), this.getArgs(event));
    }

    protected static String getServiceName(ImmutableEndpoint endpoint) {
        String pathInfo = endpoint.getEndpointURI().getPath();
        if (StringUtils.isEmpty((String)pathInfo)) {
            return endpoint.getEndpointURI().getHost();
        }
        int i = pathInfo.lastIndexOf(47);
        String serviceName = i > -1 ? pathInfo.substring(i + 1) : pathInfo;
        return serviceName;
    }

    public String parseSoapAction(String soapAction, QName method, MuleEvent event) {
        EndpointURI endpointURI = event.getEndpoint().getEndpointURI();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        MuleMessage msg = event.getMessage();
        for (String propertyKey : msg.getPropertyNames()) {
            properties.put(propertyKey, msg.getProperty(propertyKey));
        }
        properties.put("method", method.getLocalPart());
        properties.put("methodNamespace", method.getNamespaceURI());
        properties.put("address", endpointURI.getAddress());
        properties.put("scheme", endpointURI.getScheme());
        properties.put("host", endpointURI.getHost());
        properties.put("port", String.valueOf(endpointURI.getPort()));
        properties.put("path", endpointURI.getPath());
        properties.put("hostInfo", endpointURI.getScheme() + "://" + endpointURI.getHost() + (endpointURI.getPort() > -1 ? ":" + String.valueOf(endpointURI.getPort()) : ""));
        if (event.getService() != null) {
            properties.put("serviceName", event.getService().getName());
        }
        soapAction = this.soapActionTemplateParser.parse(properties, soapAction);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("SoapAction for this call is: " + soapAction));
        }
        return soapAction;
    }

    protected void configureClientForComplexTypes(Client client, MuleEvent event) throws ClassNotFoundException {
        Map complexTypes = (Map)event.getEndpoint().getProperty((Object)"complexTypes");
        Object[] beans = complexTypes.keySet().toArray();
        AegisBindingProvider bp = (AegisBindingProvider)client.getService().getBindingProvider();
        TypeMapping typeMapping = bp.getTypeMapping(client.getService());
        for (int i = 0; i < beans.length; ++i) {
            BeanType bt = new BeanType();
            String[] queue = ((String)complexTypes.get(beans[i])).split(":", 2);
            bt.setSchemaType(new QName(queue[1], queue[0]));
            bt.setTypeClass(Class.forName(beans[i].toString()));
            typeMapping.register((Type)bt);
        }
    }
}

