/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.xfire;

import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.xfire.annotations.WebAnnotations;
import org.codehaus.xfire.annotations.WebServiceAnnotation;
import org.codehaus.xfire.handler.Handler;
import org.codehaus.xfire.service.invoker.Invoker;
import org.mule.api.MuleException;
import org.mule.api.endpoint.Endpoint;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.config.converters.QNameConverter;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.soap.xfire.MuleInvoker;
import org.mule.transport.soap.xfire.XFireConnector;
import org.mule.util.ClassUtils;
import org.mule.util.MapUtils;
import org.mule.util.StringUtils;

public class XFireMessageReceiver
extends AbstractMessageReceiver {
    private static final String PORT_TYPE = "portType";
    protected XFireConnector connector;
    protected org.codehaus.xfire.service.Service xfireService;
    protected List serviceInterfaces;

    public XFireMessageReceiver(Connector umoConnector, Service service, Endpoint umoEndpoint) throws CreateException {
        super(umoConnector, service, (ImmutableEndpoint)umoEndpoint);
        this.connector = (XFireConnector)umoConnector;
        this.create();
    }

    protected void create() throws CreateException {
        try {
            Class exposedInterface;
            HashMap<String, Serializable> props = new HashMap<String, Serializable>();
            props.putAll(this.endpoint.getProperties());
            if (props.containsKey(PORT_TYPE)) {
                Object value = props.get(PORT_TYPE);
                QNameConverter converter = new QNameConverter(true);
                QName portTypeQName = (QName)converter.convert(QName.class, value);
                props.put(PORT_TYPE, portTypeQName);
            }
            String namespace = null;
            if (this.connector.isEnableJSR181Annotations()) {
                WebAnnotations wa = (WebAnnotations)ClassUtils.instanciateClass((String)"org.codehaus.xfire.annotations.jsr181.Jsr181WebAnnotations", null, ((Object)((Object)this)).getClass());
                WebServiceAnnotation webServiceAnnotation = wa.getWebServiceAnnotation(this.service.getServiceFactory().getObjectClass());
                namespace = webServiceAnnotation.getTargetNamespace();
            }
            if (namespace == null || namespace.equalsIgnoreCase("")) {
                namespace = MapUtils.getString(props, (Object)"namespace", (String)"http://www.muleumo.org");
            }
            if (props.get("createDefaultBindings") != null) {
                props.put("createDefaultBindings", Boolean.valueOf((String)props.get("createDefaultBindings")));
            }
            if (props.size() == 0) {
                props = null;
            } else {
                this.rewriteProperty(props, PORT_TYPE);
                this.rewriteProperty(props, "style");
                this.rewriteProperty(props, "use");
                this.rewriteProperty(props, "createDefaultBindings");
                this.rewriteProperty(props, "soap12Transports");
                this.rewriteProperty(props, "soap11Transports");
                this.rewriteProperty(props, "scope");
                this.rewriteProperty(props, "schemas");
            }
            if (this.serviceInterfaces == null) {
                exposedInterface = this.service.getServiceFactory().getOrCreate().getClass();
            } else {
                String className = (String)this.serviceInterfaces.get(0);
                exposedInterface = ClassUtils.loadClass((String)className, ((Object)((Object)this)).getClass());
                this.logger.info((Object)(className + " class was used to expose your service"));
                if (this.serviceInterfaces.size() > 1) {
                    this.logger.info((Object)"Only the first class was used to expose your method");
                }
            }
            String wsdlUrl = null;
            this.xfireService = StringUtils.isBlank(wsdlUrl) ? this.connector.getServiceFactory().create(exposedInterface, this.service.getName(), namespace, props) : this.connector.getServiceFactory().create(exposedInterface, new QName(namespace, this.service.getName()), new URL(wsdlUrl), props);
            List inList = this.connector.getServerInHandlers();
            if (inList != null) {
                for (int i = 0; i < inList.size(); ++i) {
                    Class clazz = ClassUtils.loadClass((String)inList.get(i).toString(), ((Object)((Object)this)).getClass());
                    Handler handler = (Handler)clazz.getConstructor(null).newInstance(null);
                    this.xfireService.addInHandler(handler);
                }
            }
            boolean sync = this.endpoint.isSynchronous();
            this.xfireService.setInvoker((Invoker)new MuleInvoker(this, sync));
        }
        catch (Exception e) {
            throw new CreateException((Throwable)e, (Object)this);
        }
    }

    protected void doDispose() {
    }

    public void doConnect() throws Exception {
        this.connector.getXfire().getServiceRegistry().register(this.xfireService);
        this.connector.registerReceiverWithMuleService((MessageReceiver)this, this.endpoint.getEndpointURI());
    }

    public void doDisconnect() throws Exception {
        this.connector.getXfire().getServiceRegistry().unregister(this.xfireService);
    }

    public void doStart() throws MuleException {
    }

    public void doStop() throws MuleException {
    }

    protected void rewriteProperty(Map props, String name) {
        if (props.containsKey(name)) {
            Object temp = props.remove(name);
            props.put("objectServiceFactory." + name, temp);
        }
    }
}

