/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.xfire;

import java.util.Iterator;
import java.util.Properties;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.client.Client;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.transport.Transport;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.transport.AbstractConnectable;
import org.mule.transport.AbstractMessageRequester;
import org.mule.transport.soap.xfire.XFireConnector;
import org.mule.transport.soap.xfire.XFireMessageDispatcher;
import org.mule.transport.soap.xfire.transport.MuleUniversalTransport;

public class XFireMessageRequester
extends AbstractMessageRequester {
    protected Client client = null;
    protected final XFireConnector connector;

    public XFireMessageRequester(ImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (XFireConnector)endpoint.getConnector();
    }

    protected void doConnect() throws Exception {
        if (this.client == null) {
            this.client = this.connector.doClientConnect(this.endpoint, (AbstractConnectable)this);
        }
    }

    protected void doDisconnect() throws Exception {
        this.client = null;
    }

    protected void doDispose() {
    }

    protected MuleMessage doRequest(long timeout) throws Exception {
        String serviceName = XFireMessageDispatcher.getServiceName(this.endpoint);
        XFire xfire = this.connector.getXfire();
        Service service = xfire.getServiceRegistry().getService(serviceName);
        Client client = new Client((Transport)new MuleUniversalTransport(), service, this.endpoint.getEndpointURI().toString());
        client.setXFire(xfire);
        client.setTimeout((int)timeout);
        client.setEndpointUri(this.endpoint.getEndpointURI().toString());
        String method = (String)this.endpoint.getProperty((Object)"method");
        OperationInfo op = service.getServiceInfo().getOperation(method);
        Properties params = this.endpoint.getEndpointURI().getUserParams();
        Object[] args = new String[params.size()];
        int i = 0;
        Iterator<Object> iterator = params.values().iterator();
        while (iterator.hasNext()) {
            args[i] = iterator.next().toString();
            ++i;
        }
        Object[] response = client.invoke(op, args);
        if (response != null && response.length == 1) {
            return new DefaultMuleMessage(response[0]);
        }
        return new DefaultMuleMessage((Object)response);
    }
}

