/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.xfire.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.attachments.Attachment;
import org.codehaus.xfire.attachments.Attachments;
import org.codehaus.xfire.attachments.ByteDataSource;
import org.codehaus.xfire.attachments.JavaMailAttachments;
import org.codehaus.xfire.attachments.SimpleAttachment;
import org.codehaus.xfire.exchange.AbstractMessage;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.soap.Soap12;
import org.codehaus.xfire.soap.SoapVersion;
import org.codehaus.xfire.transport.AbstractChannel;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.util.STAXUtils;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.RegistryContext;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.OutputHandler;
import org.mule.transport.DefaultMessageAdapter;

public class MuleUniversalChannel
extends AbstractChannel {
    protected final transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public MuleUniversalChannel(String uri, Transport transport) {
        this.setTransport(transport);
        this.setUri(uri);
    }

    public void open() {
    }

    public void send(MessageContext context, OutMessage message) throws XFireException {
        if (message.getUri().equals("urn:xfire:channel:backchannel")) {
            OutputStream out = (OutputStream)context.getProperty("urn:xfire:channel:backchannel");
            if (out == null) {
                throw new XFireRuntimeException("No backchannel exists for message");
            }
            XMLStreamWriter writer = STAXUtils.createXMLStreamWriter((OutputStream)out, (String)message.getEncoding(), (MessageContext)context);
            message.getSerializer().writeMessage(message, writer, context);
            try {
                Attachments atts = message.getAttachments();
                if (atts != null && atts.size() > 0) {
                    this.writeAttachmentBody(context, message);
                    atts.write(out);
                }
                this.writeWithoutAttachments(context, message, out);
            }
            catch (IOException e) {
                throw new XFireException("Couldn't send message.", (Throwable)e);
            }
        } else {
            try {
                this.sendViaClient(context, message);
            }
            catch (Exception e) {
                throw new XFireException("Failed to Send via MuleUniversalChannel: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    void writeWithoutAttachments(MessageContext context, OutMessage message, OutputStream out) throws XFireException {
        XMLStreamWriter writer = STAXUtils.createXMLStreamWriter((OutputStream)out, (String)message.getEncoding(), (MessageContext)context);
        message.getSerializer().writeMessage(message, writer, context);
        try {
            writer.flush();
        }
        catch (XMLStreamException e) {
            this.logger.error((Object)e);
            throw new XFireException("Couldn't send message.", (Throwable)e);
        }
    }

    void writeAttachmentBody(MessageContext context, OutMessage message) throws XFireException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.writeWithoutAttachments(context, message, (OutputStream)bos);
        Attachments atts = message.getAttachments();
        ByteDataSource ds = new ByteDataSource(bos.toByteArray());
        ds.setContentType(MuleUniversalChannel.getSoapMimeType((AbstractMessage)message));
        DataHandler dh = new DataHandler((DataSource)ds);
        SimpleAttachment att = new SimpleAttachment("soap-message.xml", dh);
        atts.setSoapMessage((Attachment)att);
    }

    String getMimeType(AbstractMessage msg) {
        Attachments atts = msg.getAttachments();
        if (atts != null && atts.size() > 0) {
            return atts.getContentType();
        }
        return MuleUniversalChannel.getSoapMimeType(msg);
    }

    static String getSoapMimeType(AbstractMessage msg) {
        SoapVersion soap = msg.getSoapVersion();
        String encoding = msg.getEncoding();
        StringBuffer soapMimeType = new StringBuffer(40);
        if (soap instanceof Soap12) {
            soapMimeType.append("application/soap+xml; charset=");
        } else {
            soapMimeType.append("text/xml; charset=");
        }
        return soapMimeType.append(encoding).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendViaClient(final MessageContext context, final OutMessage message) throws Exception {
        OutputHandler handler = new OutputHandler(){

            public void write(MuleEvent event, OutputStream out) throws IOException {
                block5: {
                    try {
                        Attachments atts = message.getAttachments();
                        if (atts != null && atts.size() > 0) {
                            atts.write(out);
                            break block5;
                        }
                        XMLStreamWriter writer = STAXUtils.createXMLStreamWriter((OutputStream)out, (String)message.getEncoding(), (MessageContext)context);
                        message.getSerializer().writeMessage(message, writer, context);
                        try {
                            writer.flush();
                            writer.close();
                        }
                        catch (XMLStreamException e) {
                            MuleUniversalChannel.this.logger.error((Object)e);
                            throw new XFireException("Couldn't send message.", (Throwable)e);
                        }
                    }
                    catch (XFireException e) {
                        MuleUniversalChannel.this.logger.error((Object)"Couldn't send message.", (Throwable)e);
                        throw new IOException(e.getMessage());
                    }
                }
            }
        };
        DefaultMessageAdapter sp = new DefaultMessageAdapter((Object)handler);
        sp.setProperty("http.method", (Object)"POST");
        this.writeHeaders(message, (MessageAdapter)sp);
        MuleMessage msg = RequestContext.getEvent().getMessage();
        for (String propertyName : msg.getPropertyNames()) {
            if (propertyName.startsWith("MULE_")) continue;
            sp.setProperty(propertyName, msg.getProperty(propertyName));
        }
        MuleMessage result = this.send(this.getUri(), (MessageAdapter)sp);
        if (result != null) {
            String contentType = sp.getStringProperty("Content-Type", "text/xml");
            InputStream in = (InputStream)result.getPayload(InputStream.class);
            try {
                InMessage inMessage;
                if (contentType.toLowerCase().indexOf("multipart/related") != -1) {
                    try {
                        JavaMailAttachments atts = new JavaMailAttachments(in, contentType);
                        InputStream msgIs = atts.getSoapMessage().getDataHandler().getInputStream();
                        inMessage = new InMessage(STAXUtils.createXMLStreamReader((InputStream)msgIs, (String)message.getEncoding(), (MessageContext)context), this.getUri());
                        inMessage.setAttachments((Attachments)atts);
                    }
                    catch (MessagingException e) {
                        throw new IOException(e.getMessage());
                    }
                } else {
                    inMessage = new InMessage(STAXUtils.createXMLStreamReader((InputStream)in, (String)message.getEncoding(), (MessageContext)context), this.getUri());
                }
                this.getEndpoint().onReceive(context, inMessage);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    this.logger.warn((Object)"Could not close stream.", (Throwable)e);
                }
            }
        }
    }

    public void writeHeaders(OutMessage message, MessageAdapter msg) {
        msg.setProperty("Content-Type", (Object)MuleUniversalChannel.getSoapMimeType((AbstractMessage)message));
        msg.setProperty("SOAPAction", message.getProperty((Object)"SOAPAction"));
        for (String headerName : msg.getPropertyNames()) {
            String headerValue = msg.getStringProperty(headerName, null);
            if (headerName.startsWith("MULE_") && "MULE_USER".compareTo(headerName) != 0 || "Content-Type".equalsIgnoreCase(headerName) || "Content-Length".equalsIgnoreCase(headerName)) continue;
            msg.setProperty(headerName, (Object)headerValue);
        }
    }

    public void close() {
    }

    public boolean isAsync() {
        return false;
    }

    protected MuleMessage send(String uri, MessageAdapter adapter) throws MuleException {
        ImmutableEndpoint ep = RegistryContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint(uri);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)adapter);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, ep, RequestContext.getEventContext().getSession(), true);
        return ep.send((MuleEvent)event);
    }
}

