/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.xmpp;

import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.mule.providers.AbstractServiceEnabledConnector;
import org.mule.umo.endpoint.UMOEndpointURI;

public class XmppConnector
extends AbstractServiceEnabledConnector {
    public static final String XMPP_PROPERTY_PREFIX = "";
    public static final String XMPP_SUBJECT = "subject";
    public static final String XMPP_THREAD = "thread";
    public static final String XMPP_TO = "to";
    public static final String XMPP_FROM = "from";
    public static final String XMPP_GROUP_CHAT = "groupChat";
    public static final String XMPP_NICKNAME = "nickname";

    public String getProtocol() {
        return "xmpp";
    }

    public XMPPConnection createXmppConnection(UMOEndpointURI endpointURI) throws XMPPException {
        this.logger.info((Object)("Trying to find XMPP connection for uri: " + endpointURI));
        XMPPConnection xmppConnection = null;
        String username = endpointURI.getUsername();
        String hostname = endpointURI.getHost();
        String password = endpointURI.getPassword();
        String resource = (String)endpointURI.getParams().get("resource");
        xmppConnection = endpointURI.getPort() != -1 ? new XMPPConnection(endpointURI.getHost(), endpointURI.getPort()) : new XMPPConnection(endpointURI.getHost());
        if (!xmppConnection.isAuthenticated()) {
            try {
                AccountManager accManager = new AccountManager(xmppConnection);
                accManager.createAccount(username, password);
            }
            catch (XMPPException ex) {
                this.logger.info((Object)("*** account (" + username + ") already exists ***"));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Logging in as: " + username));
                this.logger.debug((Object)("pw is        : " + password));
                this.logger.debug((Object)("server       : " + hostname));
                this.logger.debug((Object)("resource     : " + resource));
            }
            if (resource == null) {
                xmppConnection.login(username, password);
            } else {
                xmppConnection.login(username, password, resource);
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Already authenticated on this connection, no need to log in again.");
        }
        return xmppConnection;
    }

    protected void doDispose() {
    }

    public boolean isRemoteSyncEnabled() {
        return true;
    }
}

