/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.xmpp;

import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.mule.impl.MuleMessage;
import org.mule.impl.RequestContext;
import org.mule.providers.AbstractConnector;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.ConnectException;
import org.mule.providers.xmpp.XmppConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;

public class XmppMessageReceiver
extends AbstractMessageReceiver
implements PacketListener {
    private XMPPConnection xmppConnection = null;

    public XmppMessageReceiver(AbstractConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super((UMOConnector)connector, component, endpoint);
    }

    public void doConnect() throws Exception {
        try {
            XmppConnector cnn = (XmppConnector)this.connector;
            this.xmppConnection = cnn.createXmppConnection(this.endpoint.getEndpointURI());
            if (this.endpoint.getFilter() instanceof PacketFilter) {
                this.xmppConnection.addPacketListener((PacketListener)this, (PacketFilter)this.endpoint.getFilter());
            } else {
                PacketTypeFilter filter = new PacketTypeFilter(Message.class);
                this.xmppConnection.addPacketListener((PacketListener)this, (PacketFilter)filter);
            }
        }
        catch (XMPPException e) {
            throw new ConnectException(new org.mule.config.i18n.Message(65, (Object)"XMPP Connection"), (Throwable)e, (Object)this);
        }
    }

    public void doDisconnect() throws Exception {
        if (this.xmppConnection != null) {
            this.xmppConnection.removePacketListener((PacketListener)this);
            this.xmppConnection.close();
        }
    }

    protected void doDispose() {
        this.logger.info((Object)"Closed Xmpp Listener");
    }

    protected Work createWork(Packet message) {
        return new XMPPWorker(message);
    }

    public void processPacket(Packet packet) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("processing packet: " + packet.toXML()));
        }
        Work work = this.createWork(packet);
        try {
            this.getWorkManager().scheduleWork(work, Long.MAX_VALUE, null, (WorkListener)this.connector);
        }
        catch (WorkException e) {
            this.logger.error((Object)("Xmpp Server receiver work failed: " + e.getMessage()), (Throwable)e);
        }
    }

    private class XMPPWorker
    implements Work {
        Packet packet = null;

        public XMPPWorker(Packet message) {
            this.packet = message;
        }

        public void run() {
            try {
                UMOMessage returnMessage;
                UMOMessageAdapter adapter = XmppMessageReceiver.this.connector.getMessageAdapter((Object)this.packet);
                if (XmppMessageReceiver.this.logger.isDebugEnabled()) {
                    XmppMessageReceiver.this.logger.debug((Object)("Processing XMPP packet from: " + this.packet.getFrom()));
                    XmppMessageReceiver.this.logger.debug((Object)("UMOMessageAdapter is a: " + adapter.getClass().getName()));
                }
                if ((returnMessage = XmppMessageReceiver.this.routeMessage((UMOMessage)new MuleMessage((Object)adapter), XmppMessageReceiver.this.endpoint.isSynchronous())) != null && this.packet instanceof Message) {
                    RequestContext.rewriteEvent((UMOMessage)returnMessage);
                    Packet result = (Packet)XmppMessageReceiver.this.connector.getDefaultResponseTransformer().transform(returnMessage.getPayload());
                    XmppMessageReceiver.this.xmppConnection.sendPacket(result);
                }
            }
            catch (Exception e) {
                XmppMessageReceiver.this.handleException(e);
            }
        }

        public void release() {
        }
    }
}

