/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.xmpp;

import java.util.Iterator;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.mule.impl.ThreadSafeAccess;
import org.mule.providers.AbstractMessageAdapter;
import org.mule.umo.MessagingException;
import org.mule.umo.provider.MessageTypeNotSupportedException;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.util.StringUtils;

public class XmppMessageAdapter
extends AbstractMessageAdapter {
    public static final String DEFAULT_SUBJECT = "(no subject)";
    public static final String DEFAULT_THREAD = "(no thread)";
    private static final long serialVersionUID = -4003299444661664762L;
    private final Packet message;

    public XmppMessageAdapter(Object message) throws MessagingException {
        if (message instanceof Packet) {
            this.message = (Packet)message;
            Iterator iter = this.message.getPropertyNames();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                this.setProperty(name, this.message.getProperty(name));
            }
            if (this.message instanceof Message) {
                this.setProperty("subject", StringUtils.defaultIfEmpty((String)((Message)this.message).getSubject(), (String)DEFAULT_SUBJECT));
                this.setProperty("thread", StringUtils.defaultIfEmpty((String)((Message)this.message).getThread(), (String)DEFAULT_THREAD));
            }
        } else {
            throw new MessageTypeNotSupportedException(message, ((Object)((Object)this)).getClass());
        }
    }

    protected XmppMessageAdapter(XmppMessageAdapter template) {
        super((UMOMessageAdapter)template);
        this.message = template.message;
    }

    public String getPayloadAsString(String encoding) throws Exception {
        if (this.message instanceof Message) {
            return ((Message)this.message).getBody();
        }
        return this.message.toString();
    }

    public byte[] getPayloadAsBytes() throws Exception {
        if (this.message instanceof Message) {
            return ((Message)this.message).getBody().getBytes();
        }
        return this.message.toString().getBytes();
    }

    public Object getPayload() {
        return this.message;
    }

    public String getUniqueId() {
        return this.message.getPacketID();
    }

    public ThreadSafeAccess newThreadCopy() {
        return new XmppMessageAdapter(this);
    }
}

