/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.xmpp;

import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.GroupChat;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Message;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.xmpp.XmppConnector;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;

public class XmppMessageDispatcher
extends AbstractMessageDispatcher {
    private final XmppConnector connector;
    private volatile XMPPConnection xmppConnection = null;
    private volatile Chat chat;
    private volatile GroupChat groupChat;

    public XmppMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (XmppConnector)endpoint.getConnector();
    }

    protected void doConnect() throws Exception {
        if (this.xmppConnection == null) {
            UMOEndpointURI uri = this.endpoint.getEndpointURI();
            this.xmppConnection = this.connector.createXmppConnection(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDisconnect() throws Exception {
        try {
            if (this.groupChat != null) {
                this.groupChat.leave();
            }
            if (this.xmppConnection != null) {
                this.xmppConnection.close();
            }
        }
        finally {
            this.xmppConnection = null;
        }
    }

    protected void doDispose() {
    }

    protected void doDispatch(UMOEvent event) throws Exception {
        this.sendMessage(event);
    }

    protected UMOMessage doSend(UMOEvent event) throws Exception {
        Message response;
        this.sendMessage(event);
        if (this.useRemoteSync(event) && (response = this.groupChat != null ? this.groupChat.nextMessage((long)event.getTimeout()) : this.chat.nextMessage((long)event.getTimeout())) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Got a response from chat: " + this.chat));
            }
            return new MuleMessage((Object)this.connector.getMessageAdapter(response));
        }
        return null;
    }

    protected void sendMessage(UMOEvent event) throws Exception {
        Object msgObj;
        if (this.chat == null && this.groupChat == null) {
            UMOMessage msg = event.getMessage();
            boolean group = msg.getBooleanProperty("groupChat", false);
            String nickname = msg.getStringProperty("nickname", "mule");
            String recipient = event.getEndpoint().getEndpointURI().getPath().substring(1);
            if (group) {
                this.groupChat = new GroupChat(this.xmppConnection, recipient);
                if (!this.groupChat.isJoined()) {
                    this.groupChat.join(nickname);
                }
            } else {
                this.chat = new Chat(this.xmppConnection, recipient);
            }
        }
        Message message = !((msgObj = event.getMessage().getPayload()) instanceof Message) ? (Message)event.getTransformedMessage() : (Message)msgObj;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Transformed packet: " + message.toXML()));
        }
        if (this.chat != null) {
            this.chat.sendMessage(message);
        } else {
            this.groupChat.sendMessage(message);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Packet successfully sent");
        }
    }
}

