/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.xmpp.transformers;

import java.util.Iterator;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.XMPPError;
import org.mule.transformers.AbstractMessageAwareTransformer;
import org.mule.umo.UMOMessage;
import org.mule.umo.transformer.TransformerException;

public class ObjectToXmppPacket
extends AbstractMessageAwareTransformer {
    public ObjectToXmppPacket() {
        this.registerSourceType(String.class);
        this.registerSourceType(Message.class);
        this.setReturnClass(Message.class);
    }

    public Object transform(UMOMessage msg, String outputEncoding) throws TransformerException {
        Object src = msg.getPayload();
        if (src instanceof Message) {
            return src;
        }
        Message result = new Message();
        if (msg.getExceptionPayload() != null) {
            result.setError(new XMPPError(503, msg.getExceptionPayload().getMessage()));
        }
        Iterator iterator = msg.getPropertyNames().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (name.equals("thread")) {
                result.setThread((String)msg.getProperty(name));
                continue;
            }
            if (name.equals("subject")) {
                result.setSubject((String)msg.getProperty(name));
                continue;
            }
            if (name.equals("from")) {
                result.setFrom((String)msg.getProperty(name));
                continue;
            }
            if (name.equals("to")) {
                result.setTo((String)msg.getProperty(name));
                continue;
            }
            result.setProperty(name, msg.getProperty(name));
        }
        result.setBody((String)src);
        return result;
    }
}

