/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.Endpoint;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connectable;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageAdapter;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractConnector;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.ConnectException;
import org.mule.transport.xmpp.XmppConnector;

public class XmppMessageReceiver
extends AbstractMessageReceiver
implements PacketListener {
    private XMPPConnection xmppConnection = null;

    public XmppMessageReceiver(AbstractConnector connector, Service service, Endpoint endpoint) throws CreateException {
        super((Connector)connector, service, (ImmutableEndpoint)endpoint);
    }

    protected void doConnect() throws Exception {
        try {
            XmppConnector cnn = (XmppConnector)this.connector;
            this.xmppConnection = cnn.createXmppConnection(this.endpoint.getEndpointURI());
            if (this.endpoint.getFilter() instanceof PacketFilter) {
                this.xmppConnection.addPacketListener((PacketListener)this, (PacketFilter)this.endpoint.getFilter());
            } else {
                PacketTypeFilter filter = new PacketTypeFilter(Message.class);
                this.xmppConnection.addPacketListener((PacketListener)this, (PacketFilter)filter);
            }
        }
        catch (XMPPException e) {
            throw new ConnectException(CoreMessages.failedToCreate((String)"XMPP Connection"), (Throwable)e, (Connectable)this);
        }
    }

    protected void doDisconnect() throws Exception {
        if (this.xmppConnection != null) {
            this.xmppConnection.removePacketListener((PacketListener)this);
            this.xmppConnection.close();
        }
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    protected void doDispose() {
    }

    protected Work createWork(Packet message) {
        return new XMPPWorker(message);
    }

    public void processPacket(Packet packet) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("processing packet: " + packet.toXML()));
        }
        Work work = this.createWork(packet);
        try {
            this.getWorkManager().scheduleWork(work, Long.MAX_VALUE, null, (WorkListener)this.connector);
        }
        catch (WorkException e) {
            this.logger.error((Object)("Xmpp Server receiver work failed: " + e.getMessage()), (Throwable)e);
        }
    }

    private class XMPPWorker
    implements Work {
        Packet packet = null;

        public XMPPWorker(Packet message) {
            this.packet = message;
        }

        public void run() {
            try {
                MuleMessage returnMessage;
                MessageAdapter adapter = XmppMessageReceiver.this.connector.getMessageAdapter((Object)this.packet);
                if (XmppMessageReceiver.this.logger.isDebugEnabled()) {
                    XmppMessageReceiver.this.logger.debug((Object)("Processing XMPP packet from: " + this.packet.getFrom()));
                    XmppMessageReceiver.this.logger.debug((Object)("MessageAdapter is a: " + adapter.getClass().getName()));
                }
                if ((returnMessage = XmppMessageReceiver.this.routeMessage((MuleMessage)new DefaultMuleMessage((Object)adapter), XmppMessageReceiver.this.endpoint.isSynchronous())) != null && this.packet instanceof Message) {
                    returnMessage.applyTransformers(XmppMessageReceiver.this.connector.getDefaultResponseTransformers());
                    Packet result = (Packet)returnMessage.getPayload();
                    XmppMessageReceiver.this.xmppConnection.sendPacket(result);
                }
            }
            catch (Exception e) {
                XmppMessageReceiver.this.handleException(e);
            }
        }

        public void release() {
        }
    }
}

