/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Message;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.MalformedEndpointException;
import org.mule.transport.AbstractMessageRequester;
import org.mule.transport.xmpp.XmppConnector;

public class XmppMessageRequester
extends AbstractMessageRequester {
    private final XmppConnector connector;
    private volatile XMPPConnection xmppConnection = null;

    public XmppMessageRequester(InboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (XmppConnector)endpoint.getConnector();
    }

    protected void doConnect() throws Exception {
        if (this.xmppConnection == null) {
            EndpointURI uri = this.endpoint.getEndpointURI();
            this.xmppConnection = this.connector.createXmppConnection(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDisconnect() throws Exception {
        try {
            if (this.xmppConnection != null) {
                this.xmppConnection.close();
            }
        }
        finally {
            this.xmppConnection = null;
        }
    }

    protected void doDispose() {
    }

    protected MuleMessage doRequest(long timeout) throws Exception {
        String to = (String)this.endpoint.getProperty((Object)"folder");
        if (to == null) {
            throw new MalformedEndpointException(this.endpoint.getEndpointURI().toString());
        }
        Chat chat = this.xmppConnection.createChat(to);
        Message message = null;
        message = timeout == 0L ? chat.nextMessage() : (timeout == -1L ? chat.nextMessage(1L) : chat.nextMessage(timeout));
        if (message != null) {
            return new DefaultMuleMessage((Object)this.connector.getMessageAdapter(message), this.connector.getMuleContext());
        }
        return null;
    }
}

