/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp.transformers;

import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.XMPPError;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageAwareTransformer;

public class ObjectToXmppPacket
extends AbstractMessageAwareTransformer {
    public ObjectToXmppPacket() {
        this.registerSourceType(String.class);
        this.registerSourceType(Message.class);
        this.setReturnClass(Message.class);
    }

    public Object transform(MuleMessage muleMessage, String outputEncoding) throws TransformerException {
        Object src = muleMessage.getPayload();
        if (src instanceof Message) {
            return src;
        }
        Message result = new Message();
        if (muleMessage.getExceptionPayload() != null) {
            result.setError(new XMPPError(XMPPError.Condition.service_unavailable, muleMessage.getExceptionPayload().getMessage()));
        }
        for (String propertyName : muleMessage.getPropertyNames()) {
            if (propertyName.equals("thread")) {
                result.setThread((String)muleMessage.getProperty(propertyName));
                continue;
            }
            if (propertyName.equals("subject")) {
                result.setSubject((String)muleMessage.getProperty(propertyName));
                continue;
            }
            if (propertyName.equals("from")) {
                result.setFrom((String)muleMessage.getProperty(propertyName));
                continue;
            }
            if (propertyName.equals("to")) {
                result.setTo((String)muleMessage.getProperty(propertyName));
                continue;
            }
            result.setProperty(propertyName, muleMessage.getProperty(propertyName));
        }
        result.setBody((String)src);
        return result;
    }
}

