/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp.transformers;

import org.jivesoftware.smack.packet.Message;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageAwareTransformer;
import org.mule.util.StringUtils;

public class XmppPacketToObject
extends AbstractMessageAwareTransformer {
    public XmppPacketToObject() {
        this.registerSourceType(Message.class);
        this.setReturnClass(String.class);
    }

    public Object transform(MuleMessage muleMessage, String outputEncoding) throws TransformerException {
        Message xmppMessage = (Message)muleMessage.getPayload();
        this.copySubject(xmppMessage, muleMessage);
        this.copyThread(xmppMessage, muleMessage);
        this.copyProperties(xmppMessage, muleMessage);
        return xmppMessage.getBody();
    }

    private void copySubject(Message xmppMessage, MuleMessage muleMessage) {
        String subject = xmppMessage.getSubject();
        if (StringUtils.isNotEmpty((String)subject)) {
            muleMessage.setProperty("subject", (Object)subject);
        }
    }

    private void copyThread(Message xmppMessage, MuleMessage muleMessage) {
        String thread = xmppMessage.getThread();
        if (StringUtils.isNotEmpty((String)thread)) {
            muleMessage.setProperty("thread", (Object)thread);
        }
    }

    private void copyProperties(Message xmppMessage, MuleMessage muleMessage) {
        for (String propertyName : xmppMessage.getPropertyNames()) {
            muleMessage.setProperty(propertyName, xmppMessage.getProperty(propertyName));
        }
    }
}

