/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.transport.xmpp.AbstractXmppConversation;

public class XmppChatConversation
extends AbstractXmppConversation {
    private Chat chat;

    public XmppChatConversation(ImmutableEndpoint endpoint) {
        super(endpoint);
    }

    protected void doConnect() {
        this.chat = this.connection.getChatManager().createChat(this.recipient, null);
    }

    protected PacketFilter createPacketFilter() {
        FromMatchesFilter recipientFilter = new FromMatchesFilter(this.recipient);
        MessageTypeFilter messageTypeFilter = new MessageTypeFilter(Message.Type.chat);
        return new AndFilter(new PacketFilter[]{recipientFilter, messageTypeFilter});
    }

    protected void doDisconnect() {
        this.chat = null;
    }

    public void dispatch(Message message) throws XMPPException {
        message.setType(Message.Type.chat);
        this.chat.sendMessage(message);
    }
}

