/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp.transformers;

import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.XMPPError;
import org.mule.api.MuleMessage;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;

public class ObjectToXmppPacket
extends AbstractMessageTransformer {
    public ObjectToXmppPacket() {
        this.registerSourceType(String.class);
        this.registerSourceType(Message.class);
        this.setReturnDataType(DataTypeFactory.create(Message.class));
    }

    public Object transformMessage(MuleMessage muleMessage, String outputEncoding) {
        Object src = muleMessage.getPayload();
        if (src instanceof Message) {
            return src;
        }
        Message result = new Message();
        if (muleMessage.getExceptionPayload() != null) {
            result.setError(new XMPPError(XMPPError.Condition.service_unavailable, muleMessage.getExceptionPayload().getMessage()));
        }
        for (String propertyName : muleMessage.getOutboundPropertyNames()) {
            if (propertyName.equals("thread")) {
                result.setThread((String)muleMessage.getOutboundProperty(propertyName));
                continue;
            }
            if (propertyName.equals("subject")) {
                result.setSubject((String)muleMessage.getOutboundProperty(propertyName));
                continue;
            }
            if (propertyName.equals("from")) {
                result.setFrom((String)muleMessage.getOutboundProperty(propertyName));
                continue;
            }
            if (propertyName.equals("to")) {
                result.setTo((String)muleMessage.getOutboundProperty(propertyName));
                continue;
            }
            result.setProperty(propertyName, muleMessage.getOutboundProperty(propertyName));
        }
        result.setBody((String)src);
        return result;
    }
}

