/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp.transformers;

import org.jivesoftware.smack.packet.Message;
import org.mule.api.MuleMessage;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.StringUtils;

public class XmppPacketToObject
extends AbstractMessageTransformer {
    public XmppPacketToObject() {
        this.registerSourceType(Message.class);
        this.setReturnDataType(DataTypeFactory.create(String.class));
    }

    public Object transformMessage(MuleMessage muleMessage, String outputEncoding) {
        Message xmppMessage = (Message)muleMessage.getPayload();
        this.copySubject(xmppMessage, muleMessage);
        this.copyThread(xmppMessage, muleMessage);
        this.copyProperties(xmppMessage, muleMessage);
        return xmppMessage.getBody();
    }

    private void copySubject(Message xmppMessage, MuleMessage muleMessage) {
        String subject = xmppMessage.getSubject();
        if (StringUtils.isNotEmpty((String)subject)) {
            muleMessage.setOutboundProperty("subject", (Object)subject);
        }
    }

    private void copyThread(Message xmppMessage, MuleMessage muleMessage) {
        String thread = xmppMessage.getThread();
        if (StringUtils.isNotEmpty((String)thread)) {
            muleMessage.setOutboundProperty("thread", (Object)thread);
        }
    }

    private void copyProperties(Message xmppMessage, MuleMessage muleMessage) {
        for (String propertyName : xmppMessage.getPropertyNames()) {
            muleMessage.setOutboundProperty(propertyName, xmppMessage.getProperty(propertyName));
        }
    }
}

