/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.transport.ConnectException;
import org.mule.transport.xmpp.XmppConnector;
import org.mule.transport.xmpp.XmppConversation;

public abstract class AbstractXmppConversation
implements XmppConversation {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected XMPPConnection connection;
    protected String recipient;
    protected PacketCollector packetCollector;

    public AbstractXmppConversation(ImmutableEndpoint endpoint) {
        this.connection = ((XmppConnector)endpoint.getConnector()).getXmppConnection();
        this.recipient = XmppConnector.getRecipient(endpoint);
    }

    public void connect() throws ConnectException {
        this.doConnect();
        this.packetCollector = this.createPacketCollector();
    }

    protected void doConnect() throws ConnectException {
    }

    protected PacketCollector createPacketCollector() {
        PacketFilter filter = this.createPacketFilter();
        return this.connection.createPacketCollector(filter);
    }

    protected PacketFilter createPacketFilter() {
        return null;
    }

    public void disconnect() {
        if (this.packetCollector != null) {
            this.packetCollector.cancel();
        }
        this.doDisconnect();
    }

    protected void doDisconnect() {
    }

    public Message receive(long timeout) {
        return (Message)this.packetCollector.nextResult(timeout);
    }

    public Message receive() {
        return (Message)this.packetCollector.nextResult();
    }
}

