/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import org.mule.api.MuleRuntimeException;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.transport.xmpp.XmppChatConversation;
import org.mule.transport.xmpp.XmppConversation;
import org.mule.transport.xmpp.XmppMessageConversation;
import org.mule.transport.xmpp.XmppMessageType;
import org.mule.transport.xmpp.XmppMultiUserChatConversation;
import org.mule.transport.xmpp.i18n.XmppMessages;

public class XmppConversationFactory {
    public XmppConversation create(ImmutableEndpoint endpoint) {
        String host = endpoint.getEndpointURI().getHost();
        XmppMessageType type = XmppMessageType.valueOf(host);
        switch (type) {
            case MESSAGE: {
                return this.createMessageConversation(endpoint);
            }
            case CHAT: {
                return this.createChatConversation(endpoint);
            }
            case GROUPCHAT: {
                return this.createGroupchatConversation(endpoint);
            }
        }
        throw new MuleRuntimeException(XmppMessages.invalidConversationType(type));
    }

    protected XmppConversation createMessageConversation(ImmutableEndpoint endpoint) {
        return new XmppMessageConversation(endpoint);
    }

    protected XmppConversation createChatConversation(ImmutableEndpoint endpoint) {
        return new XmppChatConversation(endpoint);
    }

    protected XmppConversation createGroupchatConversation(ImmutableEndpoint endpoint) {
        return new XmppMultiUserChatConversation(endpoint);
    }
}

