/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.transport.AbstractConnector;
import org.mule.transport.xmpp.XmppConversationFactory;

public class XmppConnector
extends AbstractConnector {
    public static final String XMPP = "xmpp";
    public static final String XMPP_RESOURCE = "resource";
    public static final String XMPP_SUBJECT = "subject";
    public static final String XMPP_THREAD = "thread";
    public static final String XMPP_TO = "to";
    public static final String XMPP_FROM = "from";
    public static final String XMPP_GROUP_CHAT = "groupChat";
    public static final String XMPP_NICKNAME = "nickname";
    public static final String XMPP_RECIPIENT = "recipient";
    public static final String XMPP_TYPE = "type";
    private String host;
    private int port = 5222;
    private String serviceName = null;
    private String user;
    private String password;
    private String resource;
    private boolean createAccount = false;
    private XMPPConnection connection;
    private XmppConversationFactory conversationFactory = new XmppConversationFactory();

    public XmppConnector(MuleContext context) {
        super(context);
    }

    protected static String getRecipient(ImmutableEndpoint endpoint) {
        return endpoint.getEndpointURI().getPath().substring(1);
    }

    protected void doInitialise() throws InitialisationException {
        try {
            this.createXmppConnection();
        }
        catch (XMPPException ex) {
            throw new InitialisationException((Throwable)ex, (Initialisable)this);
        }
    }

    protected void doDispose() {
        this.connection = null;
    }

    protected void doConnect() throws Exception {
        this.connectToJabberServer();
    }

    protected void doDisconnect() throws Exception {
        if (this.connection.isConnected()) {
            this.connection.disconnect();
        }
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    public String getProtocol() {
        return XMPP;
    }

    protected void createXmppConnection() throws XMPPException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Connecting to " + this.host + ":" + this.port));
        }
        ConnectionConfiguration connectionConfig = null;
        connectionConfig = this.serviceName != null ? new ConnectionConfiguration(this.host, this.port, this.serviceName) : new ConnectionConfiguration(this.host, this.port);
        connectionConfig.setRosterLoadedAtLogin(false);
        this.connection = new XMPPConnection(connectionConfig);
    }

    protected void connectToJabberServer() throws XMPPException {
        this.connection.connect();
        if (this.createAccount) {
            this.createAccount();
        }
        if (this.resource != null) {
            this.connection.login(this.user, this.password, this.resource);
        } else {
            this.connection.login(this.user, this.password);
        }
    }

    private void createAccount() {
        try {
            AccountManager accountManager = new AccountManager(this.connection);
            accountManager.createAccount(this.user, this.password);
        }
        catch (XMPPException ex) {
            this.logger.warn((Object)("Account (" + this.user + ") already exists"));
        }
    }

    public boolean isResponseEnabled() {
        return true;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public boolean isCreateAccount() {
        return this.createAccount;
    }

    public void setCreateAccount(boolean createAccount) {
        this.createAccount = createAccount;
    }

    public XmppConversationFactory getConversationFactory() {
        return this.conversationFactory;
    }

    public void setConversationFactory(XmppConversationFactory conversationFactory) {
        this.conversationFactory = conversationFactory;
    }

    protected XMPPConnection getXmppConnection() {
        return this.connection;
    }
}

