/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import org.jivesoftware.smack.packet.Message;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.execution.ExecutionTemplate;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.Connector;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.xmpp.XmppConnector;
import org.mule.transport.xmpp.XmppConversation;

public class XmppPollingMessageReceiver
extends AbstractPollingMessageReceiver {
    private XmppConversation conversation;

    public XmppPollingMessageReceiver(Connector conn, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(conn, flowConstruct, endpoint);
        XmppConnector xmppConnector = (XmppConnector)conn;
        this.conversation = xmppConnector.getConversationFactory().create((ImmutableEndpoint)endpoint);
    }

    protected void doConnect() throws Exception {
        this.conversation.connect();
    }

    protected void doDisconnect() throws Exception {
        this.conversation.disconnect();
    }

    protected void doDispose() {
        this.conversation = null;
    }

    public void poll() throws Exception {
        try {
            long frequency = this.getFrequency();
            long tenPercent = (long)((double)frequency * 0.1);
            long pollTimeout = frequency - tenPercent;
            Message xmppMessage = this.conversation.receive(pollTimeout);
            if (xmppMessage == null) {
                return;
            }
            this.processMessage(xmppMessage);
        }
        catch (Exception e) {
            this.getEndpoint().getMuleContext().getExceptionListener().handleException(e);
            throw e;
        }
    }

    protected boolean pollOnPrimaryInstanceOnly() {
        return true;
    }

    protected void processMessage(final Message xmppMessage) throws MuleException {
        ExecutionTemplate executionTemplate = this.createExecutionTemplate();
        try {
            executionTemplate.execute((ExecutionCallback)new ExecutionCallback<MuleEvent>(){

                public MuleEvent process() throws Exception {
                    MuleMessage muleMessage = XmppPollingMessageReceiver.this.createMuleMessage(xmppMessage);
                    XmppPollingMessageReceiver.this.routeMessage(muleMessage);
                    return null;
                }
            });
        }
        catch (MuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DefaultMuleException((Throwable)e);
        }
    }
}

