/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.junit.Assert;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.xmpp.JabberClient;
import org.mule.transport.xmpp.JabberSender;
import org.mule.transport.xmpp.XmppEnableDisableTestCase;

public abstract class AbstractXmppTestCase
extends XmppEnableDisableTestCase {
    protected static final String COMMON_CONFIG = "xmpp-connector-config.xml,";
    private static final long JABBER_SEND_THREAD_SLEEP_TIME = 1000L;
    private static final long STARTUP_TIMEOUT = 5000L;
    private CountDownLatch jabberLatch;
    protected JabberClient jabberClient;
    protected String conversationPartner;
    protected String muleJabberUserId;

    public AbstractXmppTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, COMMON_CONFIG + configResources);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.jabberLatch = new CountDownLatch(1);
        this.createAndConnectJabberClient();
    }

    private void createAndConnectJabberClient() throws Exception {
        Properties properties = (Properties)muleContext.getRegistry().lookupObject("properties");
        String host = properties.getProperty("host");
        this.conversationPartner = properties.getProperty("conversationPartner");
        String password = properties.getProperty("conversationPartnerPassword");
        this.muleJabberUserId = properties.getProperty("xmppUser") + "@" + host;
        this.jabberClient = new JabberClient(host, this.conversationPartner, password);
        this.configureJabberClient(this.jabberClient);
        this.jabberClient.connect(this.jabberLatch);
        Assert.assertTrue((boolean)this.jabberLatch.await(5000L, TimeUnit.MILLISECONDS));
    }

    protected void configureJabberClient(JabberClient client) throws Exception {
    }

    protected void doTearDown() throws Exception {
        if (this.jabberClient != null) {
            this.jabberClient.disconnect();
        }
        super.doTearDown();
    }

    protected void sendNormalMessageFromNewThread() {
        JabberSender sender = new JabberSender(new JabberSender.Callback(){

            @Override
            public void doit() throws Exception {
                Thread.sleep(1000L);
                AbstractXmppTestCase.this.jabberClient.sendMessage(AbstractXmppTestCase.this.muleJabberUserId, "Test Message");
            }
        });
        this.startSendThread(sender);
    }

    protected void sendChatMessageFromNewThread() {
        JabberSender sender = new JabberSender(new JabberSender.Callback(){

            @Override
            public void doit() throws Exception {
                Thread.sleep(1000L);
                AbstractXmppTestCase.this.jabberClient.sendChatMessage(AbstractXmppTestCase.this.muleJabberUserId, "Test Message");
            }
        });
        this.startSendThread(sender);
    }

    protected void startSendThread(JabberSender sender) {
        Thread sendThread = new Thread(sender);
        sendThread.setName("Jabber send");
        sendThread.start();
    }

    protected void assertReceivedPacketEqualsMessageSent(Packet packet) {
        Assert.assertNotNull((Object)packet);
        Assert.assertTrue((boolean)(packet instanceof Message));
        Message messageFromJabber = (Message)packet;
        Assert.assertEquals((Object)"Test Message", (Object)messageFromJabber.getBody());
    }
}

