/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import org.jivesoftware.smack.packet.Message;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.transport.MuleMessageFactory;
import org.mule.transport.AbstractMuleMessageFactoryTestCase;
import org.mule.transport.xmpp.XmppMuleMessageFactory;
import org.mule.util.UUID;

public class XmppMuleMessageFactoryTestCase
extends AbstractMuleMessageFactoryTestCase {
    protected MuleMessageFactory doCreateMuleMessageFactory() {
        return new XmppMuleMessageFactory();
    }

    protected Object getValidTransportMessage() throws Exception {
        Message xmppMessage = new Message();
        xmppMessage.setBody("Test Message");
        return xmppMessage;
    }

    protected Object getUnsupportedTransportMessage() {
        return "this is an invalid transport message for XmppMuleMessageFactory";
    }

    @Test
    public void testPacketWithMessageProperties() throws Exception {
        String uuid = UUID.getUUID();
        Message payload = (Message)this.getValidTransportMessage();
        payload.setSubject("the subject");
        payload.setProperty("foo", (Object)"foo-value");
        payload.setPacketID(uuid);
        MuleMessageFactory factory = this.createMuleMessageFactory();
        MuleMessage message = factory.create((Object)payload, this.encoding, muleContext);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals(Message.class, message.getPayload().getClass());
        Assert.assertEquals((Object)"Test Message", (Object)((Message)message.getPayload()).getBody());
        Assert.assertEquals((Object)uuid, (Object)message.getUniqueId());
        this.assertInboundProperty("foo-value", message, "foo");
        this.assertInboundProperty("the subject", message, "subject");
    }

    private void assertInboundProperty(Object expected, MuleMessage message, String key) {
        Object value = message.getInboundProperty(key);
        Assert.assertEquals((Object)expected, (Object)value);
    }
}

