/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class XmppEndpointTestCase
extends AbstractMuleContextTestCase {
    @Test(expected=InitialisationException.class)
    public void testEndpointWithoutMessageType() throws Exception {
        MuleEndpointURI uri = new MuleEndpointURI("xmpp://mule:secret@jabber.org", muleContext);
        uri.initialise();
    }

    @Test
    public void testValidMessageEndpoint() throws Exception {
        this.doTest("xmpp://MESSAGE/mule@jabber.org", "MESSAGE");
    }

    @Test
    public void testValidChatEndpoint() throws Exception {
        this.doTest("xmpp://CHAT/mule@jabber.org", "CHAT");
    }

    @Test
    public void testValidGroupchatEndpoint() throws Exception {
        this.doTest("xmpp://GROUPCHAT/mule@jabber.org", "GROUPCHAT");
    }

    private void doTest(String uriInput, String expectedMessageType) throws Exception {
        MuleEndpointURI uri = new MuleEndpointURI(uriInput, muleContext);
        uri.initialise();
        Assert.assertEquals((Object)"xmpp", (Object)uri.getScheme());
        Assert.assertEquals((Object)expectedMessageType, (Object)uri.getHost());
        Assert.assertEquals((Object)"/mule@jabber.org", (Object)uri.getPath());
    }

    @Test(expected=InitialisationException.class)
    public void testInvalidMessageTypeEndpoint() throws Exception {
        MuleEndpointURI uri = new MuleEndpointURI("xmpp://INVALID/mule@jabber.org", muleContext);
        uri.initialise();
    }
}

