/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transformer.Transformer;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transport.xmpp.XmppConnector;
import org.mule.transport.xmpp.transformers.ObjectToXmppPacket;
import org.mule.transport.xmpp.transformers.XmppPacketToObject;

public class XmppNamespaceHandlerTestCase
extends FunctionalTestCase {
    public XmppNamespaceHandlerTestCase() {
        this.setStartContext(false);
    }

    protected String getConfigFile() {
        return "xmpp-namespace-config.xml";
    }

    @Test
    public void testConfig() throws Exception {
        XmppConnector connector = (XmppConnector)muleContext.getRegistry().lookupConnector("xmppConnector");
        Assert.assertNotNull((Object)connector);
        Assert.assertEquals((Object)"localhost", (Object)connector.getHost());
        Assert.assertEquals((long)1234L, (long)connector.getPort());
        Assert.assertEquals((Object)"jabberService", (Object)connector.getServiceName());
        Assert.assertEquals((Object)"mule", (Object)connector.getUser());
        Assert.assertEquals((Object)"secret", (Object)connector.getPassword());
        Assert.assertEquals((Object)"MuleAtWork", (Object)connector.getResource());
        Assert.assertTrue((boolean)connector.isCreateAccount());
    }

    @Test
    public void testSendingMessageEndpoint() throws Exception {
        OutboundEndpoint endpoint = this.lookupOutboundEndpoint("sendingMessageEndpoint");
        Assert.assertEquals((Object)"xmpp://MESSAGE/recipient@jabberhost", (Object)endpoint.getEndpointURI().toString());
        Assert.assertEquals((Object)"TheSubject", (Object)endpoint.getProperty((Object)"subject"));
    }

    @Test
    public void testReceivingChatEndpoint() throws Exception {
        InboundEndpoint endpoint = this.lookupInboundEndpoint("receivingChatEndpoint");
        Assert.assertEquals((Object)"xmpp://CHAT/sender@jabberhost", (Object)endpoint.getEndpointURI().toString());
    }

    @Test
    public void testTransformers() throws Exception {
        Transformer transformer = this.lookupTransformer("ObjectToXmpp");
        Assert.assertNotNull((Object)transformer);
        Assert.assertEquals(ObjectToXmppPacket.class, transformer.getClass());
        transformer = this.lookupTransformer("XmppToObject");
        Assert.assertNotNull((Object)transformer);
        Assert.assertEquals(XmppPacketToObject.class, transformer.getClass());
    }

    private OutboundEndpoint lookupOutboundEndpoint(String endpointName) throws Exception {
        EndpointBuilder endpointBuilder = this.lookupEndpointBuilder(endpointName);
        return endpointBuilder.buildOutboundEndpoint();
    }

    private InboundEndpoint lookupInboundEndpoint(String endpointName) throws Exception {
        EndpointBuilder endpointBuilder = this.lookupEndpointBuilder(endpointName);
        return endpointBuilder.buildInboundEndpoint();
    }

    private EndpointBuilder lookupEndpointBuilder(String endpointName) {
        EndpointBuilder endpointBuilder = muleContext.getRegistry().lookupEndpointBuilder(endpointName);
        Assert.assertNotNull((Object)endpointBuilder);
        return endpointBuilder;
    }

    private Transformer lookupTransformer(String transformerName) {
        Transformer transformer = muleContext.getRegistry().lookupTransformer(transformerName);
        Assert.assertNotNull((Object)transformer);
        return transformer;
    }
}

