/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.mule.util.UUID;

public class JabberClient
implements PacketListener,
MessageListener {
    private static Log logger = LogFactory.getLog(JabberClient.class);
    private String host;
    private String user;
    private String password;
    private boolean synchronous = true;
    private String replyPayload = "Reply";
    private boolean autoreply = false;
    private XMPPConnection connection;
    private Map<String, Chat> chats;
    private MultiUserChat groupchat = null;
    private List<Message> replies;
    private PacketCollector packetCollector = null;
    private CountDownLatch messageLatch = null;

    public JabberClient(String host, String user, String password) throws Exception {
        this.host = host;
        int index = user.indexOf("@");
        this.user = index > -1 ? user.substring(0, index) : user;
        this.password = password;
        this.replies = new ArrayList<Message>();
        this.chats = new HashMap<String, Chat>();
    }

    public void connect(CountDownLatch latch) throws Exception {
        ConnectionConfiguration connectionConfig = new ConnectionConfiguration(this.host);
        connectionConfig.setRosterLoadedAtLogin(false);
        this.connection = new XMPPConnection(connectionConfig);
        this.connection.connect();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("connected to " + this.host));
        }
        this.connection.login(this.user, this.password);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("logged into " + this.host + " as " + this.user));
        }
        this.registerListener();
        latch.countDown();
    }

    private void registerListener() {
        MessageTypeFilter normalTypeFilter = new MessageTypeFilter(Message.Type.normal);
        MessageTypeFilter chatTypeFilter = new MessageTypeFilter(Message.Type.chat);
        MessageTypeFilter mucTypeFilter = new MessageTypeFilter(Message.Type.groupchat);
        OrFilter filter = new OrFilter((PacketFilter)normalTypeFilter, (PacketFilter)chatTypeFilter);
        filter = new OrFilter((PacketFilter)filter, (PacketFilter)mucTypeFilter);
        if (this.synchronous) {
            this.packetCollector = this.connection.createPacketCollector((PacketFilter)filter);
        } else {
            this.connection.addPacketListener((PacketListener)this, (PacketFilter)filter);
        }
    }

    public void disconnect() {
        this.connection.removePacketListener((PacketListener)this);
        if (this.packetCollector != null) {
            this.packetCollector.cancel();
        }
        if (this.groupchat != null) {
            this.groupchat.leave();
        }
        this.chats = null;
        this.connection.disconnect();
    }

    public void processPacket(Packet packet) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("received " + packet));
        }
        this.replies.add((Message)packet);
        this.countDownMessageLatch();
        this.sendAutoreply(packet);
    }

    public void processMessage(Chat chat, Message message) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("received from chat '" + chat.getThreadID() + ": " + message));
        }
        this.replies.add(message);
        this.countDownMessageLatch();
    }

    private void countDownMessageLatch() {
        if (this.messageLatch != null) {
            this.messageLatch.countDown();
        }
    }

    private void sendAutoreply(Packet packet) {
        if (this.autoreply) {
            Message incomingMessage = (Message)packet;
            Message message = new Message();
            message.setType(incomingMessage.getType());
            message.setTo(incomingMessage.getFrom());
            message.setBody(this.replyPayload);
            this.connection.sendPacket((Packet)message);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sent autoreply message with payload: \"" + this.replyPayload + "\""));
            }
        }
    }

    public void sendMessage(String recipient, String payload) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Will send message to \"" + recipient + "\" with payload \"" + payload + "\""));
        }
        Message message = this.buildMessage(Message.Type.normal, recipient, payload);
        this.connection.sendPacket((Packet)message);
    }

    public void sendChatMessage(String recipient, String payload) throws XMPPException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Will send chat message to \"" + recipient + "\" with payload \"" + payload + "\""));
        }
        Chat chat = this.chatWith(recipient);
        Message message = this.buildMessage(Message.Type.chat, recipient, payload);
        chat.sendMessage(message);
    }

    private Chat chatWith(String recipient) {
        Chat chat = this.chats.get(recipient);
        if (chat == null) {
            chat = this.connection.getChatManager().createChat(recipient, (MessageListener)this);
            this.chats.put(recipient, chat);
        }
        return chat;
    }

    private Message buildMessage(Message.Type type, String recipient, String payload) {
        Message message = new Message();
        message.setType(type);
        String from = this.user + "@" + this.host;
        message.setFrom(from);
        message.setTo(recipient);
        message.setBody(payload);
        return message;
    }

    public List<Message> getReceivedMessages() {
        return this.replies;
    }

    public Packet receive(long timeout) {
        return this.packetCollector.nextResult(timeout);
    }

    public void joinGroupchat(String chatroom) throws XMPPException {
        this.groupchat = new MultiUserChat((Connection)this.connection, chatroom);
        this.groupchat.join(UUID.getUUID().toString());
    }

    public void sendGroupchatMessage(String text) throws XMPPException {
        this.groupchat.sendMessage(text);
    }

    public void setReplyPayload(String reply) {
        this.replyPayload = reply;
    }

    public void setAutoReply(boolean flag) {
        this.autoreply = flag;
        this.synchronous = false;
    }

    public void setSynchronous(boolean flag) {
        this.synchronous = flag;
    }

    public void setMessageLatch(CountDownLatch latch) {
        this.messageLatch = latch;
    }
}

