/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.packet.Message;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.transport.xmpp.AbstractXmppTestCase;
import org.mule.transport.xmpp.JabberClient;
import org.mule.transport.xmpp.XmppCallback;
import org.mule.util.concurrent.Latch;

public class XmppMessageAsyncTestCase
extends AbstractXmppTestCase {
    protected static final long JABBER_SEND_THREAD_SLEEP_TIME = 1000L;
    private static final String RECEIVE_SERVICE_NAME = "receiveFromJabber";
    private CountDownLatch latch = new CountDownLatch(1);

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "xmpp-message-async-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "xmpp-message-async-config-flow.xml"});
    }

    public XmppMessageAsyncTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Override
    protected void configureJabberClient(JabberClient client) {
        client.setSynchronous(false);
        client.setMessageLatch(this.latch);
    }

    @Test
    public void testDispatch() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://in", (Object)"Test Message", null);
        Assert.assertTrue((boolean)this.latch.await(5000L, TimeUnit.MILLISECONDS));
        List<Message> receivedMessages = this.jabberClient.getReceivedMessages();
        Assert.assertEquals((long)1L, (long)receivedMessages.size());
        Message message = receivedMessages.get(0);
        this.assertXmppMessage(message);
    }

    @Test
    public void testReceiveAsync() throws Exception {
        Latch receiveLatch = new Latch();
        this.setupTestServiceComponent(receiveLatch);
        this.sendJabberMessageFromNewThread();
        Assert.assertTrue((boolean)receiveLatch.await(5000L, TimeUnit.MILLISECONDS));
    }

    private void setupTestServiceComponent(Latch receiveLatch) throws Exception {
        Object testComponent = this.getComponent(RECEIVE_SERVICE_NAME);
        Assert.assertTrue((boolean)(testComponent instanceof FunctionalTestComponent));
        FunctionalTestComponent component = (FunctionalTestComponent)testComponent;
        XmppCallback callback = new XmppCallback(receiveLatch, this.expectedXmppMessageType());
        component.setEventCallback((EventCallback)callback);
    }

    protected Message.Type expectedXmppMessageType() {
        return Message.Type.normal;
    }

    protected void assertXmppMessage(Message message) {
        Assert.assertEquals((Object)Message.Type.normal, (Object)message.getType());
        Assert.assertEquals((Object)"Test Message", (Object)message.getBody());
    }

    protected void sendJabberMessageFromNewThread() {
        this.sendNormalMessageFromNewThread();
    }
}

