/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.transport.NullPayload;
import org.mule.transport.xmpp.AbstractXmppTestCase;
import org.mule.transport.xmpp.JabberSender;
import org.mule.util.UUID;
import org.mule.util.concurrent.Latch;

public class XmppMucSyncTestCase
extends AbstractXmppTestCase {
    protected static final long JABBER_SEND_THREAD_SLEEP_TIME = 1000L;
    private static final String RECEIVE_SERVICE_NAME = "receiveFromJabber";
    private static final long SHORT_RETRIEVE_TIMEOUT = 100L;
    private final String testMessage = UUID.getUUID().toString();

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "xmpp-muc-sync-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "xmpp-muc-sync-config-flow.xml"});
    }

    public XmppMucSyncTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        Properties properties = (Properties)muleContext.getRegistry().lookupObject("properties");
        String chatroom = properties.getProperty("chatroom");
        Assert.assertNotNull((Object)chatroom);
        this.jabberClient.joinGroupchat(chatroom);
    }

    @Test
    public void testSendSync() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage reply = client.send("vm://in", (Object)this.testMessage, null);
        Assert.assertNotNull((Object)reply);
        Assert.assertEquals((Object)NullPayload.getInstance(), (Object)reply.getPayload());
        Packet packet = this.jabberClient.receive(5000L);
        boolean inputSeen = false;
        packet = this.jabberClient.receive(100L);
        while (packet != null) {
            String payload = ((Message)packet).getBody();
            if (payload.equals(this.testMessage)) {
                inputSeen = true;
                break;
            }
            packet = this.jabberClient.receive(100L);
        }
        Assert.assertTrue((boolean)inputSeen);
    }

    @Test
    public void testReceiveSync() throws Exception {
        Latch receiveLatch = new Latch();
        this.setupTestServiceComponent(receiveLatch);
        this.sendMucMessageFromNewThread();
        Assert.assertTrue((boolean)receiveLatch.await(60L, TimeUnit.SECONDS));
    }

    private void setupTestServiceComponent(Latch receiveLatch) throws Exception {
        Object testComponent = this.getComponent(RECEIVE_SERVICE_NAME);
        Assert.assertTrue((boolean)(testComponent instanceof FunctionalTestComponent));
        FunctionalTestComponent component = (FunctionalTestComponent)testComponent;
        XmppGroupchatCallback callback = new XmppGroupchatCallback(receiveLatch);
        component.setEventCallback((EventCallback)callback);
    }

    protected Message.Type expectedXmppMessageType() {
        return Message.Type.groupchat;
    }

    protected void sendMucMessageFromNewThread() {
        JabberSender sender = new JabberSender(new JabberSender.Callback(){

            @Override
            public void doit() throws Exception {
                Thread.sleep(1000L);
                XmppMucSyncTestCase.this.jabberClient.sendGroupchatMessage(XmppMucSyncTestCase.this.testMessage);
            }
        });
        this.startSendThread(sender);
    }

    private class XmppGroupchatCallback
    implements EventCallback {
        private Latch latch;

        public XmppGroupchatCallback(Latch latch) {
            this.latch = latch;
        }

        public void eventReceived(MuleEventContext context, Object component) throws Exception {
            MuleMessage muleMessage = context.getMessage();
            Object payload = muleMessage.getPayload();
            Assert.assertTrue((boolean)(payload instanceof Message));
            Message jabberMessage = (Message)payload;
            if (jabberMessage.getBody().equals(XmppMucSyncTestCase.this.testMessage)) {
                this.latch.countDown();
            }
        }
    }
}

