/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Message;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transformer.DataType;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transport.xmpp.XmppConnector;
import org.mule.transport.xmpp.XmppConversationFactory;
import org.mule.transport.xmpp.XmppMessageDispatcher;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class XmppMessageDispatcherTestCase
extends AbstractMuleContextTestCase {
    @Mock
    private XMPPConnection connection;
    @Mock
    private ChatManager chatManager;
    @Mock
    private Chat chat;
    @Mock
    private XmppConnector connector;
    @Mock
    private OutboundEndpoint endpoint;
    @Mock
    private MuleEvent event;
    @Mock
    private MuleMessage message;
    @Mock
    private Message jabberMessage;

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.chatManager.createChat(Matchers.anyString(), (MessageListener)Matchers.eq(null))).thenReturn((Object)this.chat);
        Mockito.when((Object)this.connection.getChatManager()).thenReturn((Object)this.chatManager);
        Mockito.when((Object)this.connector.getConversationFactory()).thenReturn((Object)new XmppConversationFactory());
        Mockito.when((Object)this.connector.getXmppConnection()).thenReturn((Object)this.connection);
        Mockito.when((Object)this.endpoint.getEndpointURI()).thenReturn((Object)new MuleEndpointURI("xmpp://CHAT/localhost", muleContext));
        Mockito.when((Object)this.endpoint.getConnector()).thenReturn((Object)this.connector);
        Mockito.when((Object)this.event.getMessage()).thenReturn((Object)this.message);
        Mockito.when((Object)this.message.getPayload((DataType)Matchers.anyObject())).thenReturn((Object)this.jabberMessage);
    }

    @Test
    public void sendMessage() throws Exception {
        XmppMessageDispatcher dispatcher = new XmppMessageDispatcher(this.endpoint);
        dispatcher.connect();
        Mockito.when((Object)this.connection.isConnected()).thenReturn((Object)true);
        dispatcher.sendMessage(this.event);
        ((XMPPConnection)Mockito.verify((Object)this.connection, (VerificationMode)Mockito.never())).connect();
        ((Chat)Mockito.verify((Object)this.chat)).sendMessage(this.jabberMessage);
    }

    @Test
    public void sessionCloseOnServer() throws Exception {
        XmppMessageDispatcher dispatcher = new XmppMessageDispatcher(this.endpoint);
        dispatcher.connect();
        Mockito.when((Object)this.connection.isConnected()).thenReturn((Object)false);
        dispatcher.sendMessage(this.event);
        ((XMPPConnection)Mockito.verify((Object)this.connection)).connect();
        ((Chat)Mockito.verify((Object)this.chat)).sendMessage(this.jabberMessage);
    }

    @Test(expected=IllegalStateException.class)
    public void serverDownWhenSending() throws Exception {
        XmppMessageDispatcher dispatcher = new XmppMessageDispatcher(this.endpoint);
        dispatcher.connect();
        ((Chat)Mockito.doThrow(IllegalStateException.class).when((Object)this.chat)).sendMessage(this.jabberMessage);
        dispatcher.sendMessage(this.event);
    }
}

