/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.transport.NullPayload;
import org.mule.transport.xmpp.AbstractXmppTestCase;
import org.mule.transport.xmpp.XmppCallback;
import org.mule.util.concurrent.Latch;

public class XmppMessageSyncTestCase
extends AbstractXmppTestCase {
    protected static final long JABBER_SEND_THREAD_SLEEP_TIME = 1000L;
    private static final String RECEIVE_SERVICE_NAME = "receiveFromJabber";

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "xmpp-message-sync-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "xmpp-message-sync-config-flow.xml"});
    }

    public XmppMessageSyncTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testSendSync() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage reply = client.send("vm://in", (Object)"Test Message", null);
        Assert.assertNotNull((Object)reply);
        Assert.assertEquals((Object)NullPayload.getInstance(), (Object)reply.getPayload());
        Packet packet = this.jabberClient.receive(5000L);
        this.assertReceivedPacketEqualsMessageSent(packet);
    }

    @Test
    public void testReceiveSync() throws Exception {
        Latch receiveLatch = new Latch();
        this.setupTestServiceComponent(receiveLatch);
        this.sendJabberMessageFromNewThread();
        Assert.assertTrue((boolean)receiveLatch.await(5000L, TimeUnit.MILLISECONDS));
    }

    private void setupTestServiceComponent(Latch receiveLatch) throws Exception {
        Object testComponent = this.getComponent(RECEIVE_SERVICE_NAME);
        Assert.assertTrue((boolean)(testComponent instanceof FunctionalTestComponent));
        FunctionalTestComponent component = (FunctionalTestComponent)testComponent;
        XmppCallback callback = new XmppCallback(receiveLatch, this.expectedXmppMessageType());
        component.setEventCallback((EventCallback)callback);
    }

    protected void sendJabberMessageFromNewThread() {
        this.sendNormalMessageFromNewThread();
    }

    protected Message.Type expectedXmppMessageType() {
        return Message.Type.normal;
    }
}

