/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import java.util.Arrays;
import java.util.Collection;
import org.jivesoftware.smack.packet.Message;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.xmpp.AbstractXmppTestCase;

public class XmppRequestorTestCase
extends AbstractXmppTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[][]{{AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, ""}});
    }

    public XmppRequestorTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void requestMessage() throws Exception {
        this.sendNormalMessageFromNewThread();
        String url = "xmpp://MESSAGE/mule2@localhost?exchangePattern=request-response";
        this.doRequest(url, Message.Type.normal);
    }

    @Test
    public void requestChat() throws Exception {
        this.sendChatMessageFromNewThread();
        String url = "xmpp://CHAT/mule2@localhost?exchangePattern=request-response";
        this.doRequest(url, Message.Type.chat);
    }

    protected void doRequest(String url, Message.Type expectedType) throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage muleMessage = client.request(url, 5000L);
        Assert.assertNotNull((Object)muleMessage);
        Message xmppMessage = (Message)muleMessage.getPayload();
        Assert.assertEquals((Object)expectedType, (Object)xmppMessage.getType());
        Assert.assertEquals((Object)"Test Message", (Object)xmppMessage.getBody());
    }
}

