/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.benchmarks;

import java.util.concurrent.TimeUnit;
import org.benchy.AbstractBenchmarkDriver;
import org.benchy.TestCase;
import org.benchy.TestCaseResult;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class UpdateTransactionLengthDriver
extends AbstractBenchmarkDriver {
    private int transactionCount;
    private int transactionLength;
    private TransactionalInteger[] refs;

    public void preRun(TestCase testCase) {
        this.transactionCount = testCase.getIntProperty("transactionCount");
        this.transactionLength = testCase.getIntProperty("transactionLength");
        this.refs = new TransactionalInteger[this.transactionLength];
        for (int k = 0; k < this.transactionLength; ++k) {
            this.refs[k] = new TransactionalInteger();
        }
    }

    public void run() {
        for (int k = 0; k < this.transactionCount; ++k) {
            this.incAll();
        }
    }

    @TransactionalMethod
    public void incAll() {
        for (int k = 0; k < this.refs.length; ++k) {
            this.refs[k].inc();
        }
    }

    public void postRun(TestCaseResult caseResult) {
        caseResult.put("transactionCount", (Object)this.transactionCount);
        double transactionsPerSecond = 1.0 * (double)this.transactionCount * (double)TimeUnit.SECONDS.toNanos(1L) / (double)caseResult.getLongProperty("duration(ns)");
        caseResult.put("transactions/s", (Object)transactionsPerSecond);
    }
}

