/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.commitbarriers.CommitBarrierOpenException;
import org.multiverse.commitbarriers.CountDownCommitBarrier;

public class CountDownCommitBarrier_abortTest {
    private CountDownCommitBarrier barrier;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @After
    public void tearDown() {
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @Test
    public void whenNoPartiesWaiting() {
        this.barrier = new CountDownCommitBarrier(1);
        this.barrier.abort();
        Assert.assertTrue((boolean)this.barrier.isAborted());
    }

    @Test
    public void whenPartiesWaiting_theyAreAborted() {
        this.barrier = new CountDownCommitBarrier(3);
        CommitThread thread1 = new CommitThread(this.barrier);
        CommitThread thread2 = new CommitThread(this.barrier);
        TestUtils.startAll((TestThread[])new TestThread[]{thread1, thread2});
        TestUtils.sleepMs((long)500L);
        this.barrier.abort();
        TestUtils.sleepMs((long)500L);
        Assert.assertTrue((boolean)this.barrier.isAborted());
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{thread1.tx});
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{thread2.tx});
    }

    @Test
    public void whenAborted_thenIgnored() {
        this.barrier = new CountDownCommitBarrier(1);
        this.barrier.abort();
        this.barrier.abort();
        Assert.assertTrue((boolean)this.barrier.isAborted());
    }

    @Test
    public void whenCommitted_thenClosedCommitBarrierException() {
        this.barrier = new CountDownCommitBarrier(0);
        try {
            this.barrier.abort();
            Assert.fail();
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.barrier.isCommitted());
    }

    class CommitThread
    extends TestThread {
        final CountDownCommitBarrier barrier;
        Transaction tx;

        CommitThread(CountDownCommitBarrier barrier) {
            this.setPrintStackTrace(false);
            this.barrier = barrier;
        }

        @TransactionalMethod
        public void doRun() throws Exception {
            this.tx = ThreadLocalTransaction.getThreadLocalTransaction();
            this.barrier.joinCommitUninterruptibly(this.tx);
        }
    }
}

