/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.multiverse.commitbarriers.CommitBarrierOpenException;
import org.multiverse.commitbarriers.CountDownCommitBarrier;

public class CountDownCommitBarrier_registerOnCommitTaskTest {
    @Test
    public void whenNullTask_thenNullPointerException() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(1);
        try {
            barrier.registerOnCommitTask(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)barrier.isClosed());
    }

    @Test
    public void whenAborted_thenTaskNotExecuted() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(1);
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        barrier.registerOnCommitTask(task);
        barrier.abort();
        ((Runnable)Mockito.verify((Object)task, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void whenCommitted_thenTaskExecuted() throws InterruptedException {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(1);
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        barrier.registerOnCommitTask(task);
        barrier.countDown();
        ((Runnable)Mockito.verify((Object)task, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test
    public void whenTaskThrowsRuntimeException_thenOtherTasksNotExecuted() throws InterruptedException {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(1);
        Runnable task1 = (Runnable)Mockito.mock(Runnable.class);
        ((Runnable)Mockito.doThrow((Throwable)new FakeException()).when((Object)task1)).run();
        Runnable task2 = (Runnable)Mockito.mock(Runnable.class);
        barrier.registerOnCommitTask(task1);
        barrier.registerOnCommitTask(task2);
        try {
            barrier.countDown();
            Assert.fail();
        }
        catch (FakeException expected) {
            // empty catch block
        }
        ((Runnable)Mockito.verify((Object)task2, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void whenCommitted_thenCommitBarrierOpenException() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(0);
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        try {
            barrier.registerOnCommitTask(task);
            Assert.fail();
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)barrier.isCommitted());
        ((Runnable)Mockito.verify((Object)task, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void whenAborted_thenCommitBarrierOpenException() {
        CountDownCommitBarrier barrier = new CountDownCommitBarrier(1);
        barrier.abort();
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        try {
            barrier.registerOnCommitTask(task);
            Assert.fail();
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)barrier.isAborted());
        ((Runnable)Mockito.verify((Object)task, (VerificationMode)Mockito.never())).run();
    }

    static class FakeException
    extends RuntimeException {
        FakeException() {
        }
    }
}

