/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.commitbarriers.CountDownCommitBarrier;

public class CountDownCommitBarrier_tryAwaitOpenUninterruptiblyTest {
    private CountDownCommitBarrier barrier;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @After
    public void tearDown() {
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @Test
    public void whenNullTimeout_thenNullPointerException() {
        this.barrier = new CountDownCommitBarrier(1);
        try {
            this.barrier.tryAwaitOpenUninterruptibly(1L, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.barrier.isClosed());
    }

    @Test
    @Ignore
    public void whenInterruptedWhileWaiting() {
    }

    @Test
    public void whenCommittedWhileWaiting() throws InterruptedException {
        this.barrier = new CountDownCommitBarrier(1);
        TestThread t = new TestThread(){

            public void doRun() throws Exception {
                boolean result = CountDownCommitBarrier_tryAwaitOpenUninterruptiblyTest.this.barrier.tryAwaitOpenUninterruptibly(1L, TimeUnit.DAYS);
                Assert.assertTrue((boolean)result);
            }
        };
        t.start();
        TestUtils.sleepMs((long)500L);
        TestUtils.assertAlive((Thread[])new Thread[]{t});
        this.barrier.countDown();
        t.join();
        t.assertNothingThrown();
        Assert.assertTrue((boolean)this.barrier.isCommitted());
    }

    @Test
    @Ignore
    public void whenAbortedWhileWaiting() {
    }

    @Test
    @Ignore
    public void whenTimeout() {
    }

    @Test
    public void whenCommitted() {
        this.barrier = new CountDownCommitBarrier(0);
        boolean result = this.barrier.tryAwaitOpenUninterruptibly(1L, TimeUnit.DAYS);
        Assert.assertTrue((boolean)result);
        Assert.assertTrue((boolean)this.barrier.isCommitted());
    }

    @Test
    public void whenAborted() {
        this.barrier = new CountDownCommitBarrier(1);
        this.barrier.abort();
        boolean result = this.barrier.tryAwaitOpenUninterruptibly(1L, TimeUnit.DAYS);
        Assert.assertTrue((boolean)result);
        Assert.assertTrue((boolean)this.barrier.isAborted());
    }
}

