/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.commitbarriers.CommitBarrierOpenException;
import org.multiverse.commitbarriers.VetoCommitBarrier;

public class VetoCommitBarrier_setTimeoutTest {
    @Test
    public void whenNullTimeUnit_thenNullPointerException() {
        VetoCommitBarrier barrier = new VetoCommitBarrier();
        try {
            barrier.setTimeout(10L, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)barrier.isClosed());
    }

    @Test
    public void whenTimedOut() {
        VetoCommitBarrier barrier = new VetoCommitBarrier();
        barrier.setTimeout(500L, TimeUnit.MILLISECONDS);
        TestUtils.sleepMs((long)1000L);
        Assert.assertTrue((boolean)barrier.isAborted());
    }

    @Test
    public void whenCommittedBeforeTimeout() {
        VetoCommitBarrier barrier = new VetoCommitBarrier();
        barrier.setTimeout(500L, TimeUnit.MILLISECONDS);
        barrier.vetoCommit();
        TestUtils.sleepMs((long)1000L);
        Assert.assertTrue((boolean)barrier.isCommitted());
    }

    @Test
    public void whenAbortedBeforeTimeout() {
        VetoCommitBarrier barrier = new VetoCommitBarrier();
        barrier.setTimeout(500L, TimeUnit.MILLISECONDS);
        barrier.abort();
        TestUtils.sleepMs((long)1000L);
        Assert.assertTrue((boolean)barrier.isAborted());
    }

    @Test
    public void whenCommitted_thenCommitBarrierOpenException() {
        VetoCommitBarrier barrier = new VetoCommitBarrier();
        barrier.vetoCommit();
        try {
            barrier.setTimeout(10L, TimeUnit.SECONDS);
            Assert.fail();
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)barrier.isCommitted());
    }

    @Test
    public void whenAborted_thenCommitBarrierOpenException() {
        VetoCommitBarrier barrier = new VetoCommitBarrier();
        barrier.abort();
        try {
            barrier.setTimeout(10L, TimeUnit.SECONDS);
            Assert.fail();
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)barrier.isAborted());
    }
}

