/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.commitbarriers.CommitBarrierOpenException;
import org.multiverse.commitbarriers.VetoCommitBarrier;
import org.multiverse.stms.AbstractTransactionImpl;

public class VetoCommitBarrier_tryJoinCommitTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @After
    public void tearDown() {
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @Test
    public void whenOpenAndNullTransaction_thenNullPointerException() throws InterruptedException {
        VetoCommitBarrier barrier = new VetoCommitBarrier();
        try {
            barrier.tryJoinCommit(null, 1L, TimeUnit.DAYS);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)barrier.isClosed());
    }

    @Test
    @Ignore
    public void whenOpenAndTransactionPrepared_then() {
    }

    @Test
    @Ignore
    public void whenOpenAndTransactionCommitted_then() {
    }

    @Test
    @Ignore
    public void whenOpenAndTransactionAborted_then() {
    }

    @Test
    public void whenAborted_thenCommitBarrierOpenException() {
        VetoCommitBarrier barrier = new VetoCommitBarrier();
        barrier.abort();
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        try {
            barrier.tryJoinCommit((Transaction)tx);
            Assert.fail();
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)barrier.isAborted());
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenCommitted_thenCommitBarrierOpenException() {
        VetoCommitBarrier barrier = new VetoCommitBarrier();
        barrier.vetoCommit();
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        try {
            barrier.tryJoinCommit((Transaction)tx);
            Assert.fail();
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)barrier.isCommitted());
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
    }
}

