/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.TransactionStatus;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.OptimisticLockFailedWriteConflict;
import org.multiverse.commitbarriers.CommitBarrierOpenException;
import org.multiverse.commitbarriers.VetoCommitBarrier;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class VetoCommitBarrier_vetoCommitWithTransactionTest {
    private Stm stm;
    private TransactionFactory txFactory;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        this.txFactory = this.stm.getTransactionFactoryBuilder().build();
        ThreadLocalTransaction.clearThreadLocalTransaction();
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @After
    public void tearDown() {
        TestUtils.clearCurrentThreadInterruptedStatus();
    }

    @Test
    public void whenNullTx_thenNullPointerException() {
        VetoCommitBarrier barrier = new VetoCommitBarrier();
        try {
            barrier.vetoCommit(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)barrier.isClosed());
    }

    @Test
    public void whenNoPendingTransactions() {
        VetoCommitBarrier barrier = new VetoCommitBarrier();
        Transaction tx = this.txFactory.start();
        barrier.vetoCommit(tx);
        Assert.assertTrue((boolean)barrier.isCommitted());
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenPendingTransaction() throws InterruptedException {
        final VetoCommitBarrier barrier = new VetoCommitBarrier();
        final TransactionalInteger ref = new TransactionalInteger();
        TestThread t = new TestThread(){

            @TransactionalMethod
            public void doRun() throws Exception {
                ref.inc();
                Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
                barrier.joinCommit(tx);
            }
        };
        t.start();
        TestUtils.sleepMs((long)500L);
        TestUtils.assertAlive((Thread[])new Thread[]{t});
        Assert.assertTrue((boolean)barrier.isClosed());
        barrier.vetoCommit();
        t.join();
        t.assertNothingThrown();
        Assert.assertTrue((boolean)barrier.isCommitted());
        Assert.assertEquals((long)1L, (long)ref.get());
        Assert.assertEquals((long)0L, (long)barrier.getNumberWaiting());
    }

    @Test
    public void whenTransactionFailedToPrepare_thenBarrierNotAbortedOrCommitted() {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ((Transaction)Mockito.doReturn((Object)TransactionStatus.active).when((Object)tx)).getStatus();
        ((Transaction)Mockito.doThrow((Throwable)new OptimisticLockFailedWriteConflict()).when((Object)tx)).prepare();
        VetoCommitBarrier barrier = new VetoCommitBarrier();
        try {
            barrier.vetoCommit(tx);
            Assert.fail();
        }
        catch (OptimisticLockFailedWriteConflict optimisticLockFailedWriteConflict) {
            // empty catch block
        }
        Assert.assertTrue((boolean)barrier.isClosed());
    }

    @Test
    public void whenTransactionAborted_thenDeadTransactionException() {
        VetoCommitBarrier barrier = new VetoCommitBarrier();
        Transaction tx = this.txFactory.start();
        tx.abort();
        try {
            barrier.vetoCommit(tx);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertTrue((boolean)barrier.isClosed());
    }

    @Test
    public void whenTransactionCommitted_thenDeadTransactionException() {
        VetoCommitBarrier barrier = new VetoCommitBarrier();
        Transaction tx = this.txFactory.start();
        tx.commit();
        try {
            barrier.vetoCommit(tx);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertTrue((boolean)barrier.isClosed());
    }

    @Test
    public void whenBarrierCommitted_thenCommitBarrierOpenException() {
        VetoCommitBarrier barrier = new VetoCommitBarrier();
        barrier.vetoCommit();
        Transaction tx = this.txFactory.start();
        try {
            barrier.vetoCommit(tx);
            Assert.fail();
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)barrier.isCommitted());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenBarrierAborted_thenCommitBarrierOpenException() {
        VetoCommitBarrier barrier = new VetoCommitBarrier();
        barrier.abort();
        Transaction tx = this.txFactory.start();
        try {
            barrier.vetoCommit(tx);
            Assert.fail();
        }
        catch (CommitBarrierOpenException commitBarrierOpenException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)barrier.isAborted());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }
}

