/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class ConcurrentUpdateStressTest {
    public TransactionalInteger ref;
    public int incCount = 10000000;
    public int threadCount = 3;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.ref = new TransactionalInteger(0);
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        TestThread[] threads = this.createThreads();
        long startNs = System.nanoTime();
        TestUtils.startAll((TestThread[])threads);
        TestUtils.joinAll((TestThread[])threads);
        Assert.assertEquals((long)(this.threadCount * this.incCount), (long)this.ref.get());
        long periodNs = System.nanoTime() - startNs;
        double transactionPerSecond = (double)(this.incCount * this.threadCount) * 1.0 * (double)TimeUnit.SECONDS.toNanos(1L) / (double)periodNs;
        System.out.printf("%s Transaction/second\n", transactionPerSecond);
    }

    public UpdateThread[] createThreads() {
        UpdateThread[] results = new UpdateThread[this.threadCount];
        for (int k = 0; k < this.threadCount; ++k) {
            results[k] = new UpdateThread(k);
        }
        return results;
    }

    public class UpdateThread
    extends TestThread {
        public UpdateThread(int id) {
            super("UpdateThread-" + id);
        }

        public void doRun() {
            for (int k = 0; k < ConcurrentUpdateStressTest.this.incCount; ++k) {
                ConcurrentUpdateStressTest.this.ref.inc();
                if (k % 1000000 != 0) continue;
                System.out.printf("%s at %s\n", this.getName(), k);
            }
        }
    }
}

