/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalLinkedList;
import org.multiverse.transactional.collections.TransactionalList;

public class SubtypeTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenNonTransactionalInterfaceInvoked() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add("foo");
        Assert.assertEquals((Object)"[foo]", (Object)list.toString());
    }

    @Test
    public void whenNonInterfaceInvokedInsideTransactionalMethod() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        this.addFooToNormalList((List)list);
        Assert.assertEquals((Object)"[foo]", (Object)list.toString());
    }

    @TransactionalMethod
    public void addFooToNormalList(List list) {
        list.add("foo");
    }

    @Test
    public void whenTransactionalInterfaceInvoked() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        list.add((Object)"foo");
        Assert.assertEquals((Object)"[foo]", (Object)list.toString());
    }

    @Test
    public void whenTransactionalInterfaceInvokedInsideTransactionalMethod() {
        TransactionalLinkedList list = new TransactionalLinkedList();
        this.addFooToTransactionalList((TransactionalList)list);
        Assert.assertEquals((Object)"[foo]", (Object)list.toString());
    }

    @TransactionalMethod
    public void addFooToTransactionalList(TransactionalList list) {
        list.add((Object)"foo");
    }
}

