/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.classicproblems;

import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;

public class ReadersWritersProblemStressTest {
    private long count = 1000L;
    private int readerThreadCount = 10;
    private int writerThreadCount = 5;
    private ReadWriteLock readWriteLock;
    private AtomicLong currentReaderCount = new AtomicLong();
    private AtomicLong currentWriterCount = new AtomicLong();

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.readWriteLock = new UnfairReadWriteLock();
    }

    @Test
    public void test() {
        TestThread[] readers = this.createReaderThreads();
        TestThread[] writers = this.createWriterThreads();
        TestUtils.startAll((TestThread[])writers);
        TestUtils.startAll((TestThread[])readers);
        TestUtils.joinAll((TestThread[])writers);
        TestUtils.joinAll((TestThread[])readers);
        Assert.assertEquals((long)0L, (long)this.currentReaderCount.get());
        Assert.assertEquals((long)0L, (long)this.currentWriterCount.get());
    }

    private ReaderThread[] createReaderThreads() {
        ReaderThread[] readers = new ReaderThread[this.readerThreadCount];
        for (int k = 0; k < this.readerThreadCount; ++k) {
            readers[k] = new ReaderThread(k);
        }
        return readers;
    }

    private WriterThread[] createWriterThreads() {
        WriterThread[] writers = new WriterThread[this.writerThreadCount];
        for (int k = 0; k < this.writerThreadCount; ++k) {
            writers[k] = new WriterThread(k);
        }
        return writers;
    }

    private void assertNoWriters() {
        if (this.currentWriterCount.get() > 0L) {
            Assert.fail();
        }
    }

    public static interface ReadWriteLock {
        public void acquireReadLock();

        public void acquireWriteLock();

        public void releaseWriteLock();

        public void releaseReadLock();
    }

    @TransactionalObject
    static class UnfairReadWriteLock
    implements ReadWriteLock {
        private int readerCount = 0;

        @Override
        @TransactionalMethod(maxRetries=10000)
        public void acquireReadLock() {
            if (this.readerCount == -1) {
                StmUtils.retry();
            }
            ++this.readerCount;
        }

        @Override
        @TransactionalMethod(maxRetries=10000)
        public void acquireWriteLock() {
            if (this.readerCount != 0) {
                StmUtils.retry();
            }
            --this.readerCount;
        }

        @Override
        public void releaseWriteLock() {
            this.readerCount = 0;
        }

        @Override
        public void releaseReadLock() {
            --this.readerCount;
        }
    }

    public class WriterThread
    extends TestThread {
        public WriterThread(int id) {
            super("WriterThread-" + id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doRun() throws Exception {
            int k = 0;
            while ((long)k < ReadersWritersProblemStressTest.this.count) {
                ReadersWritersProblemStressTest.this.readWriteLock.acquireWriteLock();
                try {
                    this.assertNoReaders();
                    ReadersWritersProblemStressTest.this.assertNoWriters();
                    ReadersWritersProblemStressTest.this.currentWriterCount.incrementAndGet();
                    TestUtils.sleepRandomMs((int)20);
                    ReadersWritersProblemStressTest.this.currentWriterCount.decrementAndGet();
                    ReadersWritersProblemStressTest.this.assertNoWriters();
                    this.assertNoReaders();
                    if (k % 100 == 0) {
                        System.out.printf("%s is at count %s\n", this.getName(), k);
                    }
                }
                finally {
                    ReadersWritersProblemStressTest.this.readWriteLock.releaseWriteLock();
                }
                ++k;
            }
        }

        private void assertNoReaders() {
            if (ReadersWritersProblemStressTest.this.currentReaderCount.get() > 0L) {
                Assert.fail();
            }
        }
    }

    public class ReaderThread
    extends TestThread {
        public ReaderThread(int id) {
            super("ReaderThread-" + id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doRun() throws Exception {
            int k = 0;
            while ((long)k < ReadersWritersProblemStressTest.this.count) {
                ReadersWritersProblemStressTest.this.readWriteLock.acquireReadLock();
                try {
                    ReadersWritersProblemStressTest.this.assertNoWriters();
                    ReadersWritersProblemStressTest.this.currentReaderCount.incrementAndGet();
                    TestUtils.sleepRandomMs((int)2);
                    ReadersWritersProblemStressTest.this.currentReaderCount.decrementAndGet();
                    ReadersWritersProblemStressTest.this.assertNoWriters();
                    if (k % 1000 == 0) {
                        System.out.printf("%s is at count %s\n", this.getName(), k);
                    }
                }
                finally {
                    ReadersWritersProblemStressTest.this.readWriteLock.releaseReadLock();
                }
                TestUtils.sleepRandomMs((int)5);
                ++k;
            }
        }
    }
}

