/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.classicproblems;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.DefaultTransactionalReference;
import org.multiverse.transactional.collections.TransactionalLinkedList;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class SleepingBarberStressTest {
    private final int chairCount = 5;
    private BlockingQueue<TestThread> chairs;
    BarberThread barber;
    private final int customerThreadCount = 5;
    private final int customerCount = 100;
    private final AtomicInteger customerCountDown = new AtomicInteger();
    private final AtomicInteger customersTurnedAway = new AtomicInteger();
    private final AtomicLong customersServed = new AtomicLong();

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.chairs = new TransactionalLinkedList(5);
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        this.barber = new BarberThread();
        this.customerCountDown.set(100);
        TestThread[] customers = this.createCustomerThreads();
        TestUtils.startAll((TestThread[])new TestThread[]{this.barber});
        TestUtils.startAll((TestThread[])customers);
        TestUtils.joinAll((TestThread[])customers);
        this.barber.closeShop();
        TestUtils.joinAll((TestThread[])new TestThread[]{this.barber});
        Assert.assertTrue((String)"Expected the shop to be empty", (boolean)this.chairs.isEmpty());
        Assert.assertEquals((long)100L, (long)(this.customersServed.get() + (long)this.customersTurnedAway.get()));
    }

    private CustomerThread[] createCustomerThreads() {
        CustomerThread[] threads = new CustomerThread[5];
        for (int k = 0; k < threads.length; ++k) {
            threads[k] = new CustomerThread(k);
        }
        return threads;
    }

    public class CustomerThread
    extends TestThread {
        private final TransactionalInteger state;

        CustomerThread(int id) {
            super("CustomerThread-" + id);
            this.state = new TransactionalInteger();
        }

        public void doRun() {
            while (SleepingBarberStressTest.this.customerCountDown.decrementAndGet() >= 0) {
                TestUtils.sleepRandomMs((int)250);
                this.visitBarber();
                this.state.await(3);
            }
        }

        private void visitBarber() {
            if (!this.tryToSitDown()) {
                this.leaveShop();
                SleepingBarberStressTest.this.customersTurnedAway.incrementAndGet();
                return;
            }
            this.wakeBarberIfAsleep();
            assert (SleepingBarberStressTest.this.barber.isAwake()) : "The barber wasn't woken up or was woken by too many customers!";
            this.waitForTurn();
        }

        @TransactionalMethod
        private boolean tryToSitDown() {
            if (!SleepingBarberStressTest.this.chairs.offer(this)) {
                return false;
            }
            this.state.set(0);
            return true;
        }

        private int leaveShop() {
            return this.state.set(3);
        }

        @TransactionalMethod
        private void wakeBarberIfAsleep() {
            if (SleepingBarberStressTest.this.barber.isAsleep()) {
                SleepingBarberStressTest.this.barber.wakeUp();
            }
        }

        private void waitForTurn() {
            this.state.await(1);
            boolean wasSeated = SleepingBarberStressTest.this.chairs.remove((Object)this);
            assert (wasSeated) : "Customer wasn't seated?!?";
            int wasCalled = this.state.set(2);
            assert (wasCalled == 1) : String.format("Customer %s stood up but wasn't called (state: %d)?!?", this.getName(), wasCalled);
        }

        public void askForward() {
            int wasWaiting = this.state.set(1);
            assert (wasWaiting == 0) : String.format("The barber signalled a customer (%s) who wasn't waiting (state: %d)?!?", this.getName(), wasWaiting);
            this.state.await(2);
        }

        public void showOut() {
            int wasHavingHairCut = this.leaveShop();
            assert (wasHavingHairCut == 2) : String.format("Customer %s was shown out without having his/her hair cut?!?", this.getName());
        }
    }

    public class BarberThread
    extends TestThread {
        private DefaultTransactionalReference<Boolean> closingTime;
        private TransactionalInteger state;

        BarberThread() {
            super("BarberThread");
            this.closingTime = new DefaultTransactionalReference();
            this.state = new TransactionalInteger();
        }

        public void doRun() {
            this.closingTime.set((Object)false);
            this.state.set(1);
            while (true) {
                this.fallAsleepIfShopEmpty();
                this.snoozeUntilWoken();
                if (this.isClosingTime()) break;
                CustomerThread customer = (CustomerThread)((Object)SleepingBarberStressTest.this.chairs.element());
                customer.askForward();
                this.cutHair(customer);
                customer.showOut();
                SleepingBarberStressTest.this.customersServed.incrementAndGet();
            }
        }

        @TransactionalMethod
        private void fallAsleepIfShopEmpty() {
            if (SleepingBarberStressTest.this.chairs.isEmpty() && !this.isClosingTime()) {
                SleepingBarberStressTest.this.chairs.add(this);
                this.state.set(0);
            }
        }

        private void snoozeUntilWoken() {
            if (this.isAsleep()) {
                this.state.await(1);
                boolean wasSeated = SleepingBarberStressTest.this.chairs.remove((Object)this);
                assert (wasSeated) : "The barber wasn't seated?!?";
            }
        }

        private void cutHair(CustomerThread customer) {
            TestUtils.sleepRandomMs((int)50);
        }

        public void wakeUp() {
            this.state.inc();
        }

        public boolean isAsleep() {
            return this.state.get() == 0;
        }

        public boolean isAwake() {
            return this.state.get() == 1;
        }

        private boolean isClosingTime() {
            return (Boolean)this.closingTime.get();
        }

        public void closeShop() {
            this.closingTime.set((Object)true);
            this.state.set(1);
        }
    }
}

