/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.failureatomicity;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.ThreadLocalTransaction;

public class ExceptionRollbackTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenCheckedException_thenRollback() {
        Ref ref = new Ref(10);
        try {
            ref.setAndThrowChecked(20);
            Assert.fail();
        }
        catch (CheckedException checkedException) {
            // empty catch block
        }
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    @Test
    public void whenUncheckedException_thenRollback() {
        Ref ref = new Ref(10);
        try {
            ref.setAndThrowUnchecked(20);
            Assert.fail();
        }
        catch (UncheckedException uncheckedException) {
            // empty catch block
        }
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    @Test
    public void whenNonControlFlowError_thenRollback() {
        Ref ref = new Ref(10);
        try {
            ref.setAndThrowNonControlFlowError(20);
            Assert.fail();
        }
        catch (NonControlFlowError nonControlFlowError) {
            // empty catch block
        }
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    class NonControlFlowError
    extends Error {
        NonControlFlowError() {
        }
    }

    class UncheckedException
    extends RuntimeException {
        UncheckedException() {
        }
    }

    class CheckedException
    extends Exception {
        CheckedException() {
        }
    }

    @TransactionalObject
    public class Ref {
        int value;

        public Ref(int value) {
            this.value = value;
        }

        public int get() {
            return this.value;
        }

        public void setAndThrowChecked(int newValue) throws CheckedException {
            this.value = newValue;
            throw new CheckedException();
        }

        public void setAndThrowUnchecked(int newValue) {
            this.value = newValue;
            throw new UncheckedException();
        }

        public void setAndThrowNonControlFlowError(int newValue) {
            this.value = newValue;
            throw new NonControlFlowError();
        }
    }
}

