/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.failureatomicity;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class FailureAtomicityStressTest {
    private int modifyThreadCount = 10;
    private int writeCount = 1000000;
    private TransactionalInteger ref;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.ref = new TransactionalInteger();
    }

    @Test
    public void test() {
        TestThread[] modifyThreads = new ModifyThread[this.modifyThreadCount];
        for (int k = 0; k < this.modifyThreadCount; ++k) {
            modifyThreads[k] = new ModifyThread(k);
        }
        TestUtils.startAll((TestThread[])modifyThreads);
        TestUtils.joinAll((TestThread[])modifyThreads);
        int expected = this.modifyThreadCount * this.writeCount / 2;
        Assert.assertEquals((long)expected, (long)this.ref.get());
    }

    public class ModifyThread
    extends TestThread {
        public ModifyThread(int id) {
            super("ModifyThread-" + id);
        }

        public void doRun() throws Exception {
            for (int k = 0; k < FailureAtomicityStressTest.this.writeCount; ++k) {
                boolean abort;
                if (k % 50000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                boolean bl = abort = k % 2 == 0;
                if (abort) {
                    try {
                        this.modifyButAbort();
                        Assert.fail();
                    }
                    catch (DeadTransactionException deadTransactionException) {}
                    continue;
                }
                this.modify();
            }
        }

        @TransactionalMethod
        private void modify() {
            FailureAtomicityStressTest.this.ref.inc();
        }

        @TransactionalMethod
        private void modifyButAbort() {
            FailureAtomicityStressTest.this.ref.inc();
            ThreadLocalTransaction.getThreadLocalTransaction().abort();
        }
    }
}

