/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.isolation;

import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.primitives.TransactionalLong;

public class ReadConsistencyStressTest {
    private int refCount = 1000;
    private TransactionalLong[] refs;
    private final AtomicBoolean shutdown = new AtomicBoolean();
    private int readerCount = 10;
    private int writerCount = 2;
    private int readTransactionCount = 1000000;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.refs = new TransactionalLong[this.refCount];
        for (int k = 0; k < this.refs.length; ++k) {
            this.refs[k] = new TransactionalLong();
        }
        this.shutdown.set(false);
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        TestThread[] readerThreads = new ReadThread[this.readerCount];
        for (int k = 0; k < readerThreads.length; ++k) {
            readerThreads[k] = new ReadThread(k);
        }
        TestThread[] writerThreads = new WriterThread[this.writerCount];
        for (int k = 0; k < writerThreads.length; ++k) {
            writerThreads[k] = new WriterThread(k);
        }
        TestUtils.startAll((TestThread[])readerThreads);
        TestUtils.startAll((TestThread[])writerThreads);
        TestUtils.joinAll((TestThread[])readerThreads);
        TestUtils.joinAll((TestThread[])writerThreads);
    }

    public class ReadThread
    extends TestThread {
        public ReadThread(int id) {
            super("ReadThread-" + id);
        }

        public void doRun() throws Exception {
            for (int k = 0; k < ReadConsistencyStressTest.this.readTransactionCount; ++k) {
                this.read();
                if (k % 100000 != 0) continue;
                System.out.printf("%s is at %s\n", this.getName(), k);
            }
            ReadConsistencyStressTest.this.shutdown.set(true);
        }

        @TransactionalMethod(readonly=true)
        public void read() {
            long initial = ReadConsistencyStressTest.this.refs[0].get();
            for (int k = 1; k < ReadConsistencyStressTest.this.refs.length; ++k) {
                if (ReadConsistencyStressTest.this.refs[k].get() == initial) continue;
                Assert.fail();
            }
        }
    }

    public class WriterThread
    extends TestThread {
        public WriterThread(int id) {
            super("WriterThread-" + id);
        }

        public void doRun() throws Exception {
            while (!ReadConsistencyStressTest.this.shutdown.get()) {
                this.write();
                TestUtils.sleepRandomMs((int)10);
            }
        }

        @TransactionalMethod(readonly=false)
        private void write() {
            for (TransactionalLong ref : ReadConsistencyStressTest.this.refs) {
                ref.inc();
            }
        }
    }
}

