/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.isolation;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.exceptions.ReadConflict;
import org.multiverse.api.exceptions.WriteConflict;
import org.multiverse.integrationtests.Ref;

public class WriteConflictTest {
    private Stm stm;
    private TransactionFactory txFactory;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        this.txFactory = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).build();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void testLoadTimeWriteConflict() {
        Ref ref = new Ref();
        Transaction tx = this.txFactory.start();
        ref.inc();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        try {
            ref.inc();
            Assert.fail();
        }
        catch (ReadConflict readConflict) {
            // empty catch block
        }
        ThreadLocalTransaction.clearThreadLocalTransaction();
        Assert.assertEquals((long)1L, (long)ref.get());
    }

    @Test
    public void testCommitTimeWriteConflict() {
        Ref ref = new Ref();
        Transaction tx = this.txFactory.start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        ref.inc();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
        ref.inc();
        try {
            tx.commit();
            Assert.fail();
        }
        catch (WriteConflict writeConflict) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)ref.get());
    }
}

