/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.isolation;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class WriteSkewStressTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void simpleTestWithWriteSkewDetectionDisabledRepeated() {
        for (int k = 0; k < 100; ++k) {
            this.simpleTestWithWriteSkewAllowed();
        }
    }

    public void simpleTestWithWriteSkewAllowed() {
        TransactionalInteger from1 = new TransactionalInteger(100);
        TransactionalInteger from2 = new TransactionalInteger(0);
        TransactionalInteger to1 = new TransactionalInteger();
        TransactionalInteger to2 = new TransactionalInteger();
        AnotherTransferThread t1 = new AnotherTransferThread(from1, from2, to1, true);
        AnotherTransferThread t2 = new AnotherTransferThread(from2, from1, to2, true);
        t1.start();
        t2.start();
        TestUtils.joinAll((TestThread[])new TestThread[]{t1, t2});
        int sum = from1.get() + from2.get();
        Assert.assertTrue((sum < 0 ? 1 : 0) != 0);
    }

    @Test
    public void simpleWithoutWriteSkew() {
        for (int k = 0; k < 100; ++k) {
            this.simpleTestWithoutWriteSkew();
        }
    }

    public void simpleTestWithoutWriteSkew() {
        TransactionalInteger from1 = new TransactionalInteger(100);
        TransactionalInteger from2 = new TransactionalInteger(0);
        TransactionalInteger to1 = new TransactionalInteger(0);
        TransactionalInteger to2 = new TransactionalInteger(0);
        AnotherTransferThread t1 = new AnotherTransferThread(from1, from2, to1, false);
        AnotherTransferThread t2 = new AnotherTransferThread(from2, from1, to2, false);
        t2.start();
        t1.start();
        TestUtils.joinAll((TestThread[])new TestThread[]{t1, t2});
        ThreadLocalTransaction.clearThreadLocalTransaction();
        int sum = from1.get() + from2.get();
        Assert.assertTrue((String)("sumRefs " + sum), (sum >= 0 ? 1 : 0) != 0);
    }

    private class AnotherTransferThread
    extends TestThread {
        final TransactionalInteger from1;
        final TransactionalInteger from2;
        final TransactionalInteger to;
        final boolean writeSkewAllowed;

        private AnotherTransferThread(TransactionalInteger from1, TransactionalInteger from2, TransactionalInteger to, boolean writeSkewAllowed) {
            this.from1 = from1;
            this.from2 = from2;
            this.to = to;
            this.writeSkewAllowed = writeSkewAllowed;
        }

        public void doRun() throws Exception {
            if (this.writeSkewAllowed) {
                this.doRunWriteSkewAllowed();
            } else {
                this.doRunWriteSkewDisallowed();
            }
        }

        @TransactionalMethod(trackReads=true, writeSkew=false)
        public void doRunWriteSkewDisallowed() throws Exception {
            this.doIt();
        }

        @TransactionalMethod(trackReads=true, writeSkew=true)
        public void doRunWriteSkewAllowed() throws Exception {
            this.doIt();
        }

        private void doIt() {
            if (this.from1.get() + this.from2.get() >= 100) {
                this.from1.dec(100);
                this.to.inc(100);
            }
            TestUtils.sleepMs((long)200L);
        }
    }
}

