/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.notification;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class ActorStressTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        PrintActor actor = new PrintActor();
        TestThread t = this.threadActor(actor);
        actor.send(new TextMessage("hello"));
        actor.send(new PoisonMessage());
        TestUtils.joinAll((TestThread[])new TestThread[]{t});
    }

    @Test
    public void test2() {
        SumActor sumActor = new SumActor();
        this.threadActor(sumActor);
        StartActor startActor = new StartActor(sumActor);
        this.threadActor(startActor);
        startActor.send(new StartMessage(1, 2));
        TestUtils.sleepMs((long)1000L);
    }

    public TestThread threadActor(final Actor actor) {
        TestThread t = new TestThread(){

            public void doRun() throws Exception {
                while (actor.run()) {
                }
            }
        };
        t.start();
        return t;
    }

    public abstract class Actor {
        private final TransactionalLinkedList<Message> mailbox = new TransactionalLinkedList();

        public boolean run() {
            Message message = (Message)this.mailbox.takeUninterruptible();
            this.receive(message);
            return !(message instanceof PoisonMessage);
        }

        private void receive(Message message) {
            try {
                Method m = this.getClass().getMethod("receive", message.getClass());
                m.invoke((Object)this, message);
            }
            catch (NoSuchMethodException e) {
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public void send(Message msg) {
            this.mailbox.add((Object)msg);
        }
    }

    public class PoisonMessage
    implements Message {
    }

    public static interface Message {
    }

    public class ResultMessage
    implements Message {
        int a;
    }

    public class SumActor
    extends Actor {
        public void receive(CalcMessage message) {
            ResultMessage msg = new ResultMessage();
            msg.a = message.a + message.b;
            message.sender.send(msg);
        }
    }

    public class StartMessage
    implements Message {
        int a;
        int b;

        public StartMessage(int a, int b) {
            this.a = a;
            this.b = b;
        }
    }

    public class StartActor
    extends Actor {
        private SumActor sumActor;

        public StartActor(SumActor sumActor) {
            this.sumActor = sumActor;
        }

        public void receive(StartMessage startMsg) {
            CalcMessage msg = new CalcMessage();
            msg.sender = this;
            msg.a = startMsg.a;
            msg.b = startMsg.b;
            this.sumActor.send(msg);
        }

        public void receive(ResultMessage msg) {
            System.out.println("result was: " + msg.a);
        }
    }

    public class CalcMessage
    implements Message {
        int a;
        int b;
        Actor sender;
    }

    public class TextMessage
    implements Message {
        public String text;

        public TextMessage(String text) {
            this.text = text;
        }
    }

    public class PrintActor
    extends Actor {
        public void receive(TextMessage msg) {
            System.out.println(msg.text);
        }
    }
}

